<?php

namespace Service;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Redeemable Service
 * @subpackage Services
 * @date 2019-10-21
 */
class Redeemable extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named RedeemableItemDetails
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Struct\RedeemableItemDetails $parameters
     * @return \Struct\RedeemableItemDetailsResponse|bool
     */
    public function RedeemableItemDetails(\Struct\RedeemableItemDetails $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RedeemableItemDetails($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Struct\RedeemableItemDetailsResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
