<?php

namespace Service;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Redeem Service
 * @subpackage Services
 * @date 2019-10-21
 */
class Redeem extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named RedeemItems
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Struct\RedeemItems $parameters
     * @return \Struct\RedeemItemsResponse|bool
     */
    public function RedeemItems(\Struct\RedeemItems $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RedeemItems($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RedeemItemsBeta
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Struct\RedeemItemsBeta $parameters
     * @return \Struct\RedeemItemsBetaResponse|bool
     */
    public function RedeemItemsBeta(\Struct\RedeemItemsBeta $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RedeemItemsBeta($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Struct\RedeemItemsBetaResponse|\Struct\RedeemItemsResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
