<?php

namespace Service;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Password Service
 * @subpackage Services
 * @date 2019-10-21
 */
class Password extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named PasswordRequest
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Struct\PasswordRequest $parameters
     * @return \Struct\PasswordRequestResponse|bool
     */
    public function PasswordRequest(\Struct\PasswordRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->PasswordRequest($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Struct\PasswordRequestResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
