<?php

namespace Service;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Give Service
 * @subpackage Services
 * @date 2019-10-21
 */
class Give extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GivePoints
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Struct\GivePoints $parameters
     * @return \Struct\GivePointsResponse|bool
     */
    public function GivePoints(\Struct\GivePoints $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GivePoints($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Struct\GivePointsResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
