<?php

namespace Service;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get Service
 * @subpackage Services
 * @date 2019-10-21
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GetMyWalletsWithPoints
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Struct\GetMyWalletsWithPoints $parameters
     * @return \Struct\GetMyWalletsWithPointsResponse|bool
     */
    public function GetMyWalletsWithPoints(\Struct\GetMyWalletsWithPoints $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetMyWalletsWithPoints($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetMyWalletsWithStockPoints
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Struct\GetMyWalletsWithStockPoints $parameters
     * @return \Struct\GetMyWalletsWithStockPointsResponse|bool
     */
    public function GetMyWalletsWithStockPoints(\Struct\GetMyWalletsWithStockPoints $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetMyWalletsWithStockPoints($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCommandPrice
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Struct\GetCommandPrice $parameters
     * @return \Struct\GetCommandPriceResponse|bool
     */
    public function GetCommandPrice(\Struct\GetCommandPrice $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetCommandPrice($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCommandRestrictions
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Struct\GetCommandRestrictions $parameters
     * @return \Struct\GetCommandRestrictionsResponse|bool
     */
    public function GetCommandRestrictions(\Struct\GetCommandRestrictions $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetCommandRestrictions($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetLineMembersWalletsCount
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Struct\GetLineMembersWalletsCount $parameters
     * @return \Struct\GetLineMembersWalletsCountResponse|bool
     */
    public function GetLineMembersWalletsCount(\Struct\GetLineMembersWalletsCount $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetLineMembersWalletsCount($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetLineMembersPoints
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Struct\GetLineMembersPoints $parameters
     * @return \Struct\GetLineMembersPointsResponse|bool
     */
    public function GetLineMembersPoints(\Struct\GetLineMembersPoints $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetLineMembersPoints($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAvailableWalletsForCommand
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Struct\GetAvailableWalletsForCommand $parameters
     * @return \Struct\GetAvailableWalletsForCommandResponse|bool
     */
    public function GetAvailableWalletsForCommand(\Struct\GetAvailableWalletsForCommand $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetAvailableWalletsForCommand($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetTransferDetails
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Struct\GetTransferDetails $parameters
     * @return \Struct\GetTransferDetailsResponse|bool
     */
    public function GetTransferDetails(\Struct\GetTransferDetails $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetTransferDetails($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetOrdersSummary
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Struct\GetOrdersSummary $parameters
     * @return \Struct\GetOrdersSummaryResponse|bool
     */
    public function GetOrdersSummary(\Struct\GetOrdersSummary $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetOrdersSummary($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCataloguesSummary
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Struct\GetCataloguesSummary $parameters
     * @return \Struct\GetCataloguesSummaryResponse|bool
     */
    public function GetCataloguesSummary(\Struct\GetCataloguesSummary $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetCataloguesSummary($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * GetAccountMembersWithRegistrationInfo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Struct\GetAccountMembersWithRegistrationInfo $parameters
     * @return \Struct\GetAccountMembersWithRegistrationInfoResponse|bool
     */
    public function GetAccountMembersWithRegistrationInfo(\Struct\GetAccountMembersWithRegistrationInfo $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetAccountMembersWithRegistrationInfo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetLostPoints
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Struct\GetLostPoints $parameters
     * @return \Struct\GetLostPointsResponse|bool
     */
    public function GetLostPoints(\Struct\GetLostPoints $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetLostPoints($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetNextRedemptionDate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Struct\GetNextRedemptionDate $parameters
     * @return \Struct\GetNextRedemptionDateResponse|bool
     */
    public function GetNextRedemptionDate(\Struct\GetNextRedemptionDate $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetNextRedemptionDate($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetDeliveryChannels
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Struct\GetDeliveryChannels $parameters
     * @return \Struct\GetDeliveryChannelsResponse|bool
     */
    public function GetDeliveryChannels(\Struct\GetDeliveryChannels $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetDeliveryChannels($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAvailableQuantity
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Struct\GetAvailableQuantity $parameters
     * @return \Struct\GetAvailableQuantityResponse|bool
     */
    public function GetAvailableQuantity(\Struct\GetAvailableQuantity $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetAvailableQuantity($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetDeliveryChannelTypes
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Struct\GetDeliveryChannelTypes $parameters
     * @return \Struct\GetDeliveryChannelTypesResponse|bool
     */
    public function GetDeliveryChannelTypes(\Struct\GetDeliveryChannelTypes $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetDeliveryChannelTypes($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAreas
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Struct\GetAreas $parameters
     * @return \Struct\GetAreasResponse|bool
     */
    public function GetAreas(\Struct\GetAreas $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetAreas($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetArea
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Struct\GetArea $parameters
     * @return \Struct\GetAreaResponse|bool
     */
    public function GetArea(\Struct\GetArea $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetArea($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Struct\GetAccountMembersWithRegistrationInfoResponse|\Struct\GetAreaResponse|\Struct\GetAreasResponse|\Struct\GetAvailableQuantityResponse|\Struct\GetAvailableWalletsForCommandResponse|\Struct\GetCataloguesSummaryResponse|\Struct\GetCommandPriceResponse|\Struct\GetCommandRestrictionsResponse|\Struct\GetDeliveryChannelsResponse|\Struct\GetDeliveryChannelTypesResponse|\Struct\GetLineMembersPointsResponse|\Struct\GetLineMembersWalletsCountResponse|\Struct\GetLostPointsResponse|\Struct\GetMyWalletsWithPointsResponse|\Struct\GetMyWalletsWithStockPointsResponse|\Struct\GetNextRedemptionDateResponse|\Struct\GetOrdersSummaryResponse|\Struct\GetTransferDetailsResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
