<?php

namespace Service;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Deliver Service
 * @subpackage Services
 * @date 2019-10-21
 */
class Deliver extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named DeliverItems
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Struct\DeliverItems $parameters
     * @return \Struct\DeliverItemsResponse|bool
     */
    public function DeliverItems(\Struct\DeliverItems $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->DeliverItems($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Struct\DeliverItemsResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
