<?php

namespace Array;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfPurchaseOrderItem Array
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfPurchaseOrderItem
 * @subpackage Arrays
 * @date 2019-10-21
 */
class ArrayOfPurchaseOrderItem extends AbstractStructArrayBase
{
    /**
     * The PurchaseOrderItem
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \Struct\PurchaseOrderItem[]
     */
    public $PurchaseOrderItem;
    /**
     * Constructor method for ArrayOfPurchaseOrderItem
     * @uses ArrayOfPurchaseOrderItem::setPurchaseOrderItem()
     * @param \Struct\PurchaseOrderItem[] $purchaseOrderItem
     */
    public function __construct(array $purchaseOrderItem = array())
    {
        $this
            ->setPurchaseOrderItem($purchaseOrderItem);
    }
    /**
     * Get PurchaseOrderItem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Struct\PurchaseOrderItem[]|null
     */
    public function getPurchaseOrderItem()
    {
        return isset($this->PurchaseOrderItem) ? $this->PurchaseOrderItem : null;
    }
    /**
     * This method is responsible for validating the values passed to the setPurchaseOrderItem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPurchaseOrderItem method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePurchaseOrderItemForArrayConstraintsFromSetPurchaseOrderItem(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfPurchaseOrderItemPurchaseOrderItemItem) {
            // validation for constraint: itemType
            if (!$arrayOfPurchaseOrderItemPurchaseOrderItemItem instanceof \Struct\PurchaseOrderItem) {
                $invalidValues[] = is_object($arrayOfPurchaseOrderItemPurchaseOrderItemItem) ? get_class($arrayOfPurchaseOrderItemPurchaseOrderItemItem) : sprintf('%s(%s)', gettype($arrayOfPurchaseOrderItemPurchaseOrderItemItem), var_export($arrayOfPurchaseOrderItemPurchaseOrderItemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PurchaseOrderItem property can only contain items of type \Struct\PurchaseOrderItem, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PurchaseOrderItem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \Struct\PurchaseOrderItem[] $purchaseOrderItem
     * @return \Array\ArrayOfPurchaseOrderItem
     */
    public function setPurchaseOrderItem(array $purchaseOrderItem = array())
    {
        // validation for constraint: array
        if ('' !== ($purchaseOrderItemArrayErrorMessage = self::validatePurchaseOrderItemForArrayConstraintsFromSetPurchaseOrderItem($purchaseOrderItem))) {
            throw new \InvalidArgumentException($purchaseOrderItemArrayErrorMessage, __LINE__);
        }
        if (is_null($purchaseOrderItem) || (is_array($purchaseOrderItem) && empty($purchaseOrderItem))) {
            unset($this->PurchaseOrderItem);
        } else {
            $this->PurchaseOrderItem = $purchaseOrderItem;
        }
        return $this;
    }
    /**
     * Add item to PurchaseOrderItem value
     * @throws \InvalidArgumentException
     * @param \Struct\PurchaseOrderItem $item
     * @return \Array\ArrayOfPurchaseOrderItem
     */
    public function addToPurchaseOrderItem(\Struct\PurchaseOrderItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Struct\PurchaseOrderItem) {
            throw new \InvalidArgumentException(sprintf('The PurchaseOrderItem property can only contain items of type \Struct\PurchaseOrderItem, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PurchaseOrderItem[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \Struct\PurchaseOrderItem|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \Struct\PurchaseOrderItem|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \Struct\PurchaseOrderItem|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \Struct\PurchaseOrderItem|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \Struct\PurchaseOrderItem|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string PurchaseOrderItem
     */
    public function getAttributeName()
    {
        return 'PurchaseOrderItem';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \Array\ArrayOfPurchaseOrderItem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
