<?php

namespace MoniWSI\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Update ServiceType
 * @subpackage Services
 */
class Update extends AbstractSoapClientBase
{
    /**
     * Sets the ApplicationIDHeader SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \MoniWSI\StructType\ApplicationIDHeader $applicationIDHeader
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderApplicationIDHeader(\MoniWSI\StructType\ApplicationIDHeader $applicationIDHeader, $nameSpace = 'http://schemas.nevatech.com/services/', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'ApplicationIDHeader', $applicationIDHeader, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named Update
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: ApplicationIDHeader
     * - SOAPHeaderNamespaces: http://schemas.nevatech.com/services/
     * - SOAPHeaderTypes: \MoniWSI\StructType\ApplicationIDHeader
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \MoniWSI\StructType\Update $parameters
     * @return \MoniWSI\StructType\UpdateResponse|bool
     */
    public function Update(\MoniWSI\StructType\Update $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->Update($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateCreditRequest
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \MoniWSI\StructType\UpdateCreditRequest $parameters
     * @return \MoniWSI\StructType\UpdateCreditRequestResponse|bool
     */
    public function UpdateCreditRequest(\MoniWSI\StructType\UpdateCreditRequest $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->UpdateCreditRequest($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdatePurchaseInfo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \MoniWSI\StructType\UpdatePurchaseInfo $parameters
     * @return \MoniWSI\StructType\UpdatePurchaseInfoResponse|bool
     */
    public function UpdatePurchaseInfo(\MoniWSI\StructType\UpdatePurchaseInfo $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->UpdatePurchaseInfo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \MoniWSI\StructType\UpdateCreditRequestResponse|\MoniWSI\StructType\UpdatePurchaseInfoResponse|\MoniWSI\StructType\UpdateResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
