<?php

namespace MoniWSI\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Immediate ServiceType
 * @subpackage Services
 */
class Immediate extends AbstractSoapClientBase
{
    /**
     * Sets the ApplicationIDHeader SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \MoniWSI\StructType\ApplicationIDHeader $applicationIDHeader
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderApplicationIDHeader(\MoniWSI\StructType\ApplicationIDHeader $applicationIDHeader, $nameSpace = 'http://schemas.nevatech.com/services/', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'ApplicationIDHeader', $applicationIDHeader, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named Immediate
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: ApplicationIDHeader
     * - SOAPHeaderNamespaces: http://schemas.nevatech.com/services/
     * - SOAPHeaderTypes: \MoniWSI\StructType\ApplicationIDHeader
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \MoniWSI\StructType\Immediate $parameters
     * @return \MoniWSI\StructType\ImmediateResponse|bool
     */
    public function Immediate(\MoniWSI\StructType\Immediate $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->Immediate($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \MoniWSI\StructType\ImmediateResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
