<?php

namespace MoniWSI\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DetermineMODAccess StructType
 * @subpackage Structs
 */
class DetermineMODAccess extends AbstractStructBase
{
    /**
     * The ContactNo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ContactNo;
    /**
     * The CustomerNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerNumber;
    /**
     * Constructor method for DetermineMODAccess
     * @uses DetermineMODAccess::setContactNo()
     * @uses DetermineMODAccess::setCustomerNumber()
     * @param int $contactNo
     * @param string $customerNumber
     */
    public function __construct($contactNo = null, $customerNumber = null)
    {
        $this
            ->setContactNo($contactNo)
            ->setCustomerNumber($customerNumber);
    }
    /**
     * Get ContactNo value
     * @return int
     */
    public function getContactNo()
    {
        return $this->ContactNo;
    }
    /**
     * Set ContactNo value
     * @param int $contactNo
     * @return \MoniWSI\StructType\DetermineMODAccess
     */
    public function setContactNo($contactNo = null)
    {
        // validation for constraint: int
        if (!is_null($contactNo) && !is_numeric($contactNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($contactNo)), __LINE__);
        }
        $this->ContactNo = $contactNo;
        return $this;
    }
    /**
     * Get CustomerNumber value
     * @return string|null
     */
    public function getCustomerNumber()
    {
        return $this->CustomerNumber;
    }
    /**
     * Set CustomerNumber value
     * @param string $customerNumber
     * @return \MoniWSI\StructType\DetermineMODAccess
     */
    public function setCustomerNumber($customerNumber = null)
    {
        // validation for constraint: string
        if (!is_null($customerNumber) && !is_string($customerNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($customerNumber)), __LINE__);
        }
        $this->CustomerNumber = $customerNumber;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \MoniWSI\StructType\DetermineMODAccess
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
