<?php

namespace MoniWSI\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccountOnline StructType
 * @subpackage Structs
 */
class AccountOnline extends AbstractStructBase
{
    /**
     * The userName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $userName;
    /**
     * The password
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $password;
    /**
     * The csNo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $csNo;
    /**
     * The xml
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $xml;
    /**
     * The creditRequestXml
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $creditRequestXml;
    /**
     * The purchaseInfoXml
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $purchaseInfoXml;
    /**
     * Constructor method for AccountOnline
     * @uses AccountOnline::setUserName()
     * @uses AccountOnline::setPassword()
     * @uses AccountOnline::setCsNo()
     * @uses AccountOnline::setXml()
     * @uses AccountOnline::setCreditRequestXml()
     * @uses AccountOnline::setPurchaseInfoXml()
     * @param string $userName
     * @param string $password
     * @param string $csNo
     * @param string $xml
     * @param string $creditRequestXml
     * @param string $purchaseInfoXml
     */
    public function __construct($userName = null, $password = null, $csNo = null, $xml = null, $creditRequestXml = null, $purchaseInfoXml = null)
    {
        $this
            ->setUserName($userName)
            ->setPassword($password)
            ->setCsNo($csNo)
            ->setXml($xml)
            ->setCreditRequestXml($creditRequestXml)
            ->setPurchaseInfoXml($purchaseInfoXml);
    }
    /**
     * Get userName value
     * @return string|null
     */
    public function getUserName()
    {
        return $this->userName;
    }
    /**
     * Set userName value
     * @param string $userName
     * @return \MoniWSI\StructType\AccountOnline
     */
    public function setUserName($userName = null)
    {
        // validation for constraint: string
        if (!is_null($userName) && !is_string($userName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($userName)), __LINE__);
        }
        $this->userName = $userName;
        return $this;
    }
    /**
     * Get password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->password;
    }
    /**
     * Set password value
     * @param string $password
     * @return \MoniWSI\StructType\AccountOnline
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($password)), __LINE__);
        }
        $this->password = $password;
        return $this;
    }
    /**
     * Get csNo value
     * @return string|null
     */
    public function getCsNo()
    {
        return $this->csNo;
    }
    /**
     * Set csNo value
     * @param string $csNo
     * @return \MoniWSI\StructType\AccountOnline
     */
    public function setCsNo($csNo = null)
    {
        // validation for constraint: string
        if (!is_null($csNo) && !is_string($csNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($csNo)), __LINE__);
        }
        $this->csNo = $csNo;
        return $this;
    }
    /**
     * Get xml value
     * @return string|null
     */
    public function getXml()
    {
        return $this->xml;
    }
    /**
     * Set xml value
     * @param string $xml
     * @return \MoniWSI\StructType\AccountOnline
     */
    public function setXml($xml = null)
    {
        // validation for constraint: string
        if (!is_null($xml) && !is_string($xml)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($xml)), __LINE__);
        }
        $this->xml = $xml;
        return $this;
    }
    /**
     * Get creditRequestXml value
     * @return string|null
     */
    public function getCreditRequestXml()
    {
        return $this->creditRequestXml;
    }
    /**
     * Set creditRequestXml value
     * @param string $creditRequestXml
     * @return \MoniWSI\StructType\AccountOnline
     */
    public function setCreditRequestXml($creditRequestXml = null)
    {
        // validation for constraint: string
        if (!is_null($creditRequestXml) && !is_string($creditRequestXml)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($creditRequestXml)), __LINE__);
        }
        $this->creditRequestXml = $creditRequestXml;
        return $this;
    }
    /**
     * Get purchaseInfoXml value
     * @return string|null
     */
    public function getPurchaseInfoXml()
    {
        return $this->purchaseInfoXml;
    }
    /**
     * Set purchaseInfoXml value
     * @param string $purchaseInfoXml
     * @return \MoniWSI\StructType\AccountOnline
     */
    public function setPurchaseInfoXml($purchaseInfoXml = null)
    {
        // validation for constraint: string
        if (!is_null($purchaseInfoXml) && !is_string($purchaseInfoXml)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($purchaseInfoXml)), __LINE__);
        }
        $this->purchaseInfoXml = $purchaseInfoXml;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \MoniWSI\StructType\AccountOnline
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
