<?php

namespace MoniWSI\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GetData
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \MoniWSI\StructType\GetData $parameters
     * @return \MoniWSI\StructType\GetDataResponse|bool
     */
    public function GetData(\MoniWSI\StructType\GetData $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetData($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCreditRequest
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \MoniWSI\StructType\GetCreditRequest $parameters
     * @return \MoniWSI\StructType\GetCreditRequestResponse|bool
     */
    public function GetCreditRequest(\MoniWSI\StructType\GetCreditRequest $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetCreditRequest($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetPurchaseInfo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \MoniWSI\StructType\GetPurchaseInfo $parameters
     * @return \MoniWSI\StructType\GetPurchaseInfoResponse|bool
     */
    public function GetPurchaseInfo(\MoniWSI\StructType\GetPurchaseInfo $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetPurchaseInfo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetDealerCMRates
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \MoniWSI\StructType\GetDealerCMRates $parameters
     * @return \MoniWSI\StructType\GetDealerCMRatesResponse|bool
     */
    public function GetDealerCMRates(\MoniWSI\StructType\GetDealerCMRates $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetDealerCMRates($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetTimezoneFromZipcode
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \MoniWSI\StructType\GetTimezoneFromZipcode $parameters
     * @return \MoniWSI\StructType\GetTimezoneFromZipcodeResponse|bool
     */
    public function GetTimezoneFromZipcode(\MoniWSI\StructType\GetTimezoneFromZipcode $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetTimezoneFromZipcode($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetWebServiceVersion
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \MoniWSI\StructType\GetWebServiceVersion $parameters
     * @return \MoniWSI\StructType\GetWebServiceVersionResponse|bool
     */
    public function GetWebServiceVersion(\MoniWSI\StructType\GetWebServiceVersion $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetWebServiceVersion($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \MoniWSI\StructType\GetCreditRequestResponse|\MoniWSI\StructType\GetDataResponse|\MoniWSI\StructType\GetDealerCMRatesResponse|\MoniWSI\StructType\GetPurchaseInfoResponse|\MoniWSI\StructType\GetTimezoneFromZipcodeResponse|\MoniWSI\StructType\GetWebServiceVersionResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
