<?php

namespace MoniWSI\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Update StructType
 * @subpackage Structs
 */
class Update extends AbstractStructBase
{
    /**
     * The userName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $userName;
    /**
     * The password
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $password;
    /**
     * The reqType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $reqType;
    /**
     * The csNo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $csNo;
    /**
     * The xml
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $xml;
    /**
     * Constructor method for Update
     * @uses Update::setUserName()
     * @uses Update::setPassword()
     * @uses Update::setReqType()
     * @uses Update::setCsNo()
     * @uses Update::setXml()
     * @param string $userName
     * @param string $password
     * @param string $reqType
     * @param string $csNo
     * @param string $xml
     */
    public function __construct($userName = null, $password = null, $reqType = null, $csNo = null, $xml = null)
    {
        $this
            ->setUserName($userName)
            ->setPassword($password)
            ->setReqType($reqType)
            ->setCsNo($csNo)
            ->setXml($xml);
    }
    /**
     * Get userName value
     * @return string|null
     */
    public function getUserName()
    {
        return $this->userName;
    }
    /**
     * Set userName value
     * @param string $userName
     * @return \MoniWSI\StructType\Update
     */
    public function setUserName($userName = null)
    {
        // validation for constraint: string
        if (!is_null($userName) && !is_string($userName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($userName)), __LINE__);
        }
        $this->userName = $userName;
        return $this;
    }
    /**
     * Get password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->password;
    }
    /**
     * Set password value
     * @param string $password
     * @return \MoniWSI\StructType\Update
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($password)), __LINE__);
        }
        $this->password = $password;
        return $this;
    }
    /**
     * Get reqType value
     * @return string|null
     */
    public function getReqType()
    {
        return $this->reqType;
    }
    /**
     * Set reqType value
     * @param string $reqType
     * @return \MoniWSI\StructType\Update
     */
    public function setReqType($reqType = null)
    {
        // validation for constraint: string
        if (!is_null($reqType) && !is_string($reqType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($reqType)), __LINE__);
        }
        $this->reqType = $reqType;
        return $this;
    }
    /**
     * Get csNo value
     * @return string|null
     */
    public function getCsNo()
    {
        return $this->csNo;
    }
    /**
     * Set csNo value
     * @param string $csNo
     * @return \MoniWSI\StructType\Update
     */
    public function setCsNo($csNo = null)
    {
        // validation for constraint: string
        if (!is_null($csNo) && !is_string($csNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($csNo)), __LINE__);
        }
        $this->csNo = $csNo;
        return $this;
    }
    /**
     * Get xml value
     * @return string|null
     */
    public function getXml()
    {
        return $this->xml;
    }
    /**
     * Set xml value
     * @param string $xml
     * @return \MoniWSI\StructType\Update
     */
    public function setXml($xml = null)
    {
        // validation for constraint: string
        if (!is_null($xml) && !is_string($xml)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($xml)), __LINE__);
        }
        $this->xml = $xml;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \MoniWSI\StructType\Update
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
