<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://mimasweb.monitronics.net/MIDI/MIDI.asmx?wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://mimasweb.monitronics.net/MIDI/MIDI.asmx?wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => \wsi\ClassMap::get(),
);
/**
 * Samples for Account ServiceType
 */
$account = new \wsi\ServiceType\Account($options);
$account->setSoapHeaderApplicationIDHeader(new \wsi\StructType\ApplicationIDHeader());
/**
 * Sample call for AccountOnline operation/method
 */
if ($account->AccountOnline(new \wsi\StructType\AccountOnline()) !== false) {
    print_r($account->getResult());
} else {
    print_r($account->getLastError());
}
/**
 * Samples for Get ServiceType
 */
$get = new \wsi\ServiceType\Get($options);
/**
 * Sample call for GetData operation/method
 */
if ($get->GetData(new \wsi\StructType\GetData()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetCreditRequest operation/method
 */
if ($get->GetCreditRequest(new \wsi\StructType\GetCreditRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetPurchaseInfo operation/method
 */
if ($get->GetPurchaseInfo(new \wsi\StructType\GetPurchaseInfo()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetDealerCMRates operation/method
 */
if ($get->GetDealerCMRates(new \wsi\StructType\GetDealerCMRates()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetTimezoneFromZipcode operation/method
 */
if ($get->GetTimezoneFromZipcode(new \wsi\StructType\GetTimezoneFromZipcode()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetWebServiceVersion operation/method
 */
if ($get->GetWebServiceVersion(new \wsi\StructType\GetWebServiceVersion()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Samples for Immediate ServiceType
 */
$immediate = new \wsi\ServiceType\Immediate($options);
$immediate->setSoapHeaderApplicationIDHeader(new \wsi\StructType\ApplicationIDHeader());
/**
 * Sample call for Immediate operation/method
 */
if ($immediate->Immediate(new \wsi\StructType\Immediate()) !== false) {
    print_r($immediate->getResult());
} else {
    print_r($immediate->getLastError());
}
/**
 * Samples for Update ServiceType
 */
$update = new \wsi\ServiceType\Update($options);
$update->setSoapHeaderApplicationIDHeader(new \wsi\StructType\ApplicationIDHeader());
/**
 * Sample call for Update operation/method
 */
if ($update->Update(new \wsi\StructType\Update()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for UpdateCreditRequest operation/method
 */
if ($update->UpdateCreditRequest(new \wsi\StructType\UpdateCreditRequest()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for UpdatePurchaseInfo operation/method
 */
if ($update->UpdatePurchaseInfo(new \wsi\StructType\UpdatePurchaseInfo()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Samples for Partial ServiceType
 */
$partial = new \wsi\ServiceType\Partial($options);
$partial->setSoapHeaderApplicationIDHeader(new \wsi\StructType\ApplicationIDHeader());
/**
 * Sample call for Partial operation/method
 */
if ($partial->Partial(new \wsi\StructType\Partial()) !== false) {
    print_r($partial->getResult());
} else {
    print_r($partial->getLastError());
}
/**
 * Samples for Determine ServiceType
 */
$determine = new \wsi\ServiceType\Determine($options);
$determine->setSoapHeaderApplicationIDHeader(new \wsi\StructType\ApplicationIDHeader());
/**
 * Sample call for DetermineMODAccess operation/method
 */
if ($determine->DetermineMODAccess(new \wsi\StructType\DetermineMODAccess()) !== false) {
    print_r($determine->getResult());
} else {
    print_r($determine->getLastError());
}
