<?php

namespace wsi\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Immediate StructType
 * @subpackage Structs
 */
class Immediate extends AbstractStructBase
{
    /**
     * The Entity
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Entity;
    /**
     * The UserID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UserID;
    /**
     * The Password
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Password;
    /**
     * The CustomerNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerNumber;
    /**
     * The XMLData
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $XMLData;
    /**
     * Constructor method for Immediate
     * @uses Immediate::setEntity()
     * @uses Immediate::setUserID()
     * @uses Immediate::setPassword()
     * @uses Immediate::setCustomerNumber()
     * @uses Immediate::setXMLData()
     * @param string $entity
     * @param string $userID
     * @param string $password
     * @param string $customerNumber
     * @param string $xMLData
     */
    public function __construct($entity = null, $userID = null, $password = null, $customerNumber = null, $xMLData = null)
    {
        $this
            ->setEntity($entity)
            ->setUserID($userID)
            ->setPassword($password)
            ->setCustomerNumber($customerNumber)
            ->setXMLData($xMLData);
    }
    /**
     * Get Entity value
     * @return string|null
     */
    public function getEntity()
    {
        return $this->Entity;
    }
    /**
     * Set Entity value
     * @param string $entity
     * @return \wsi\StructType\Immediate
     */
    public function setEntity($entity = null)
    {
        // validation for constraint: string
        if (!is_null($entity) && !is_string($entity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($entity)), __LINE__);
        }
        $this->Entity = $entity;
        return $this;
    }
    /**
     * Get UserID value
     * @return string|null
     */
    public function getUserID()
    {
        return $this->UserID;
    }
    /**
     * Set UserID value
     * @param string $userID
     * @return \wsi\StructType\Immediate
     */
    public function setUserID($userID = null)
    {
        // validation for constraint: string
        if (!is_null($userID) && !is_string($userID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($userID)), __LINE__);
        }
        $this->UserID = $userID;
        return $this;
    }
    /**
     * Get Password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->Password;
    }
    /**
     * Set Password value
     * @param string $password
     * @return \wsi\StructType\Immediate
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($password)), __LINE__);
        }
        $this->Password = $password;
        return $this;
    }
    /**
     * Get CustomerNumber value
     * @return string|null
     */
    public function getCustomerNumber()
    {
        return $this->CustomerNumber;
    }
    /**
     * Set CustomerNumber value
     * @param string $customerNumber
     * @return \wsi\StructType\Immediate
     */
    public function setCustomerNumber($customerNumber = null)
    {
        // validation for constraint: string
        if (!is_null($customerNumber) && !is_string($customerNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($customerNumber)), __LINE__);
        }
        $this->CustomerNumber = $customerNumber;
        return $this;
    }
    /**
     * Get XMLData value
     * @return string|null
     */
    public function getXMLData()
    {
        return $this->XMLData;
    }
    /**
     * Set XMLData value
     * @param string $xMLData
     * @return \wsi\StructType\Immediate
     */
    public function setXMLData($xMLData = null)
    {
        // validation for constraint: string
        if (!is_null($xMLData) && !is_string($xMLData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($xMLData)), __LINE__);
        }
        $this->XMLData = $xMLData;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \wsi\StructType\Immediate
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
