<?php

namespace wsi;

/**
 * Class which returns the class map definition
 * @package
 */
class ClassMap
{
    /**
     * Returns the mapping between the WSDL Structs and generated Structs' classes
     * This array is sent to the \SoapClient when calling the WS
     * @return string[]
     */
    final public static function get()
    {
        return array(
            'AccountOnline' => '\\wsi\\StructType\\AccountOnline',
            'ApplicationIDHeader' => '\\wsi\\StructType\\ApplicationIDHeader',
            'AccountOnlineResponse' => '\\wsi\\StructType\\AccountOnlineResponse',
            'AccountOnlineResult' => '\\wsi\\StructType\\AccountOnlineResult',
            'GetData' => '\\wsi\\StructType\\GetData',
            'GetDataResponse' => '\\wsi\\StructType\\GetDataResponse',
            'GetDataResult' => '\\wsi\\StructType\\GetDataResult',
            'Immediate' => '\\wsi\\StructType\\Immediate',
            'ImmediateResponse' => '\\wsi\\StructType\\ImmediateResponse',
            'ImmediateResult' => '\\wsi\\StructType\\ImmediateResult',
            'Update' => '\\wsi\\StructType\\Update',
            'UpdateResponse' => '\\wsi\\StructType\\UpdateResponse',
            'UpdateResult' => '\\wsi\\StructType\\UpdateResult',
            'Partial' => '\\wsi\\StructType\\Partial',
            'PartialResponse' => '\\wsi\\StructType\\PartialResponse',
            'PartialResult' => '\\wsi\\StructType\\PartialResult',
            'DetermineMODAccess' => '\\wsi\\StructType\\DetermineMODAccess',
            'DetermineMODAccessResponse' => '\\wsi\\StructType\\DetermineMODAccessResponse',
            'GetCreditRequest' => '\\wsi\\StructType\\GetCreditRequest',
            'GetCreditRequestResponse' => '\\wsi\\StructType\\GetCreditRequestResponse',
            'UpdateCreditRequest' => '\\wsi\\StructType\\UpdateCreditRequest',
            'UpdateCreditRequestResponse' => '\\wsi\\StructType\\UpdateCreditRequestResponse',
            'GetPurchaseInfo' => '\\wsi\\StructType\\GetPurchaseInfo',
            'GetPurchaseInfoResponse' => '\\wsi\\StructType\\GetPurchaseInfoResponse',
            'UpdatePurchaseInfo' => '\\wsi\\StructType\\UpdatePurchaseInfo',
            'UpdatePurchaseInfoResponse' => '\\wsi\\StructType\\UpdatePurchaseInfoResponse',
            'GetDealerCMRates' => '\\wsi\\StructType\\GetDealerCMRates',
            'GetDealerCMRatesResponse' => '\\wsi\\StructType\\GetDealerCMRatesResponse',
            'GetDealerCMRatesResult' => '\\wsi\\StructType\\GetDealerCMRatesResult',
            'GetTimezoneFromZipcode' => '\\wsi\\StructType\\GetTimezoneFromZipcode',
            'GetTimezoneFromZipcodeResponse' => '\\wsi\\StructType\\GetTimezoneFromZipcodeResponse',
            'GetTimezoneFromZipcodeResult' => '\\wsi\\StructType\\GetTimezoneFromZipcodeResult',
            'GetWebServiceVersion' => '\\wsi\\StructType\\GetWebServiceVersion',
            'GetWebServiceVersionResponse' => '\\wsi\\StructType\\GetWebServiceVersionResponse',
        );
    }
}
