<?php

namespace wsi\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Determine ServiceType
 * @subpackage Services
 */
class Determine extends AbstractSoapClientBase
{
    /**
     * Sets the ApplicationIDHeader SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \wsi\StructType\ApplicationIDHeader $applicationIDHeader
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderApplicationIDHeader(\wsi\StructType\ApplicationIDHeader $applicationIDHeader, $nameSpace = 'http://schemas.nevatech.com/services/', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'ApplicationIDHeader', $applicationIDHeader, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named DetermineMODAccess
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: ApplicationIDHeader
     * - SOAPHeaderNamespaces: http://schemas.nevatech.com/services/
     * - SOAPHeaderTypes: \wsi\StructType\ApplicationIDHeader
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \wsi\StructType\DetermineMODAccess $parameters
     * @return \wsi\StructType\DetermineMODAccessResponse|bool
     */
    public function DetermineMODAccess(\wsi\StructType\DetermineMODAccess $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->DetermineMODAccess($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \wsi\StructType\DetermineMODAccessResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
