<?php

namespace wsi\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GetData
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \wsi\StructType\GetData $parameters
     * @return \wsi\StructType\GetDataResponse|bool
     */
    public function GetData(\wsi\StructType\GetData $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetData($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCreditRequest
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \wsi\StructType\GetCreditRequest $parameters
     * @return \wsi\StructType\GetCreditRequestResponse|bool
     */
    public function GetCreditRequest(\wsi\StructType\GetCreditRequest $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetCreditRequest($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetPurchaseInfo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \wsi\StructType\GetPurchaseInfo $parameters
     * @return \wsi\StructType\GetPurchaseInfoResponse|bool
     */
    public function GetPurchaseInfo(\wsi\StructType\GetPurchaseInfo $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetPurchaseInfo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetDealerCMRates
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \wsi\StructType\GetDealerCMRates $parameters
     * @return \wsi\StructType\GetDealerCMRatesResponse|bool
     */
    public function GetDealerCMRates(\wsi\StructType\GetDealerCMRates $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetDealerCMRates($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetTimezoneFromZipcode
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \wsi\StructType\GetTimezoneFromZipcode $parameters
     * @return \wsi\StructType\GetTimezoneFromZipcodeResponse|bool
     */
    public function GetTimezoneFromZipcode(\wsi\StructType\GetTimezoneFromZipcode $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetTimezoneFromZipcode($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetWebServiceVersion
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \wsi\StructType\GetWebServiceVersion $parameters
     * @return \wsi\StructType\GetWebServiceVersionResponse|bool
     */
    public function GetWebServiceVersion(\wsi\StructType\GetWebServiceVersion $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetWebServiceVersion($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \wsi\StructType\GetCreditRequestResponse|\wsi\StructType\GetDataResponse|\wsi\StructType\GetDealerCMRatesResponse|\wsi\StructType\GetPurchaseInfoResponse|\wsi\StructType\GetTimezoneFromZipcodeResponse|\wsi\StructType\GetWebServiceVersionResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
