<?php

namespace CountryInfoServiceTest\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for List ServiceType
 * @subpackage Services
 */
class _List extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ListOfContinentsByName
     * Meta information extracted from the WSDL
     * - documentation: Returns a list of continents ordered by name.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CountryInfoServiceTest\StructType\ListOfContinentsByName $parameters
     * @return \CountryInfoServiceTest\StructType\ListOfContinentsByNameResponse|bool
     */
    public function ListOfContinentsByName(\CountryInfoServiceTest\StructType\ListOfContinentsByName $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ListOfContinentsByName($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListOfContinentsByCode
     * Meta information extracted from the WSDL
     * - documentation: Returns a list of continents ordered by code.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CountryInfoServiceTest\StructType\ListOfContinentsByCode $parameters
     * @return \CountryInfoServiceTest\StructType\ListOfContinentsByCodeResponse|bool
     */
    public function ListOfContinentsByCode(\CountryInfoServiceTest\StructType\ListOfContinentsByCode $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ListOfContinentsByCode($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListOfCurrenciesByName
     * Meta information extracted from the WSDL
     * - documentation: Returns a list of currencies ordered by name.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CountryInfoServiceTest\StructType\ListOfCurrenciesByName $parameters
     * @return \CountryInfoServiceTest\StructType\ListOfCurrenciesByNameResponse|bool
     */
    public function ListOfCurrenciesByName(\CountryInfoServiceTest\StructType\ListOfCurrenciesByName $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ListOfCurrenciesByName($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListOfCurrenciesByCode
     * Meta information extracted from the WSDL
     * - documentation: Returns a list of currencies ordered by code.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CountryInfoServiceTest\StructType\ListOfCurrenciesByCode $parameters
     * @return \CountryInfoServiceTest\StructType\ListOfCurrenciesByCodeResponse|bool
     */
    public function ListOfCurrenciesByCode(\CountryInfoServiceTest\StructType\ListOfCurrenciesByCode $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ListOfCurrenciesByCode($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListOfCountryNamesByCode
     * Meta information extracted from the WSDL
     * - documentation: Returns a list of all stored counties ordered by ISO code
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CountryInfoServiceTest\StructType\ListOfCountryNamesByCode $parameters
     * @return \CountryInfoServiceTest\StructType\ListOfCountryNamesByCodeResponse|bool
     */
    public function ListOfCountryNamesByCode(\CountryInfoServiceTest\StructType\ListOfCountryNamesByCode $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ListOfCountryNamesByCode($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListOfCountryNamesByName
     * Meta information extracted from the WSDL
     * - documentation: Returns a list of all stored counties ordered by country name
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CountryInfoServiceTest\StructType\ListOfCountryNamesByName $parameters
     * @return \CountryInfoServiceTest\StructType\ListOfCountryNamesByNameResponse|bool
     */
    public function ListOfCountryNamesByName(\CountryInfoServiceTest\StructType\ListOfCountryNamesByName $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ListOfCountryNamesByName($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * ListOfCountryNamesGroupedByContinent
     * Meta information extracted from the WSDL
     * - documentation: Returns a list of all stored counties grouped per continent
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CountryInfoServiceTest\StructType\ListOfCountryNamesGroupedByContinent $parameters
     * @return \CountryInfoServiceTest\StructType\ListOfCountryNamesGroupedByContinentResponse|bool
     */
    public function ListOfCountryNamesGroupedByContinent(\CountryInfoServiceTest\StructType\ListOfCountryNamesGroupedByContinent $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ListOfCountryNamesGroupedByContinent($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListOfLanguagesByName
     * Meta information extracted from the WSDL
     * - documentation: Returns an array of languages ordered by name
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CountryInfoServiceTest\StructType\ListOfLanguagesByName $parameters
     * @return \CountryInfoServiceTest\StructType\ListOfLanguagesByNameResponse|bool
     */
    public function ListOfLanguagesByName(\CountryInfoServiceTest\StructType\ListOfLanguagesByName $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ListOfLanguagesByName($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListOfLanguagesByCode
     * Meta information extracted from the WSDL
     * - documentation: Returns an array of languages ordered by code
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CountryInfoServiceTest\StructType\ListOfLanguagesByCode $parameters
     * @return \CountryInfoServiceTest\StructType\ListOfLanguagesByCodeResponse|bool
     */
    public function ListOfLanguagesByCode(\CountryInfoServiceTest\StructType\ListOfLanguagesByCode $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ListOfLanguagesByCode($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \CountryInfoServiceTest\StructType\ListOfContinentsByCodeResponse|\CountryInfoServiceTest\StructType\ListOfContinentsByNameResponse|\CountryInfoServiceTest\StructType\ListOfCountryNamesByCodeResponse|\CountryInfoServiceTest\StructType\ListOfCountryNamesByNameResponse|\CountryInfoServiceTest\StructType\ListOfCountryNamesGroupedByContinentResponse|\CountryInfoServiceTest\StructType\ListOfCurrenciesByCodeResponse|\CountryInfoServiceTest\StructType\ListOfCurrenciesByNameResponse|\CountryInfoServiceTest\StructType\ListOfLanguagesByCodeResponse|\CountryInfoServiceTest\StructType\ListOfLanguagesByNameResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
