<?php

namespace CountryInfoServiceTest\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Language ServiceType
 * @subpackage Services
 */
class Language extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named LanguageName
     * Meta information extracted from the WSDL
     * - documentation: Find a language name based on the passed ISO language code
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CountryInfoServiceTest\StructType\LanguageName $parameters
     * @return \CountryInfoServiceTest\StructType\LanguageNameResponse|bool
     */
    public function LanguageName(\CountryInfoServiceTest\StructType\LanguageName $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->LanguageName($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named LanguageISOCode
     * Meta information extracted from the WSDL
     * - documentation: Find a language ISO code based on the passed language name
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CountryInfoServiceTest\StructType\LanguageISOCode $parameters
     * @return \CountryInfoServiceTest\StructType\LanguageISOCodeResponse|bool
     */
    public function LanguageISOCode(\CountryInfoServiceTest\StructType\LanguageISOCode $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->LanguageISOCode($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \CountryInfoServiceTest\StructType\LanguageISOCodeResponse|\CountryInfoServiceTest\StructType\LanguageNameResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
