<?php

namespace CountryInfoServiceTest\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOftLanguage ArrayType
 * @subpackage Arrays
 */
class ArrayOftLanguage extends AbstractStructArrayBase
{
    /**
     * The tLanguage
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \CountryInfoServiceTest\StructType\TLanguage[]
     */
    public $tLanguage;
    /**
     * Constructor method for ArrayOftLanguage
     * @uses ArrayOftLanguage::setTLanguage()
     * @param \CountryInfoServiceTest\StructType\TLanguage[] $tLanguage
     */
    public function __construct(array $tLanguage = array())
    {
        $this
            ->setTLanguage($tLanguage);
    }
    /**
     * Get tLanguage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \CountryInfoServiceTest\StructType\TLanguage[]|null
     */
    public function getTLanguage()
    {
        return isset($this->tLanguage) ? $this->tLanguage : null;
    }
    /**
     * This method is responsible for validating the values passed to the setTLanguage method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTLanguage method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTLanguageForArrayConstraintsFromSetTLanguage(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOftLanguageTLanguageItem) {
            // validation for constraint: itemType
            if (!$arrayOftLanguageTLanguageItem instanceof \CountryInfoServiceTest\StructType\TLanguage) {
                $invalidValues[] = is_object($arrayOftLanguageTLanguageItem) ? get_class($arrayOftLanguageTLanguageItem) : sprintf('%s(%s)', gettype($arrayOftLanguageTLanguageItem), var_export($arrayOftLanguageTLanguageItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The tLanguage property can only contain items of type \CountryInfoServiceTest\StructType\TLanguage, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set tLanguage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \CountryInfoServiceTest\StructType\TLanguage[] $tLanguage
     * @return \CountryInfoServiceTest\ArrayType\ArrayOftLanguage
     */
    public function setTLanguage(array $tLanguage = array())
    {
        // validation for constraint: array
        if ('' !== ($tLanguageArrayErrorMessage = self::validateTLanguageForArrayConstraintsFromSetTLanguage($tLanguage))) {
            throw new \InvalidArgumentException($tLanguageArrayErrorMessage, __LINE__);
        }
        if (is_null($tLanguage) || (is_array($tLanguage) && empty($tLanguage))) {
            unset($this->tLanguage);
        } else {
            $this->tLanguage = $tLanguage;
        }
        return $this;
    }
    /**
     * Add item to tLanguage value
     * @throws \InvalidArgumentException
     * @param \CountryInfoServiceTest\StructType\TLanguage $item
     * @return \CountryInfoServiceTest\ArrayType\ArrayOftLanguage
     */
    public function addToTLanguage(\CountryInfoServiceTest\StructType\TLanguage $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \CountryInfoServiceTest\StructType\TLanguage) {
            throw new \InvalidArgumentException(sprintf('The tLanguage property can only contain items of type \CountryInfoServiceTest\StructType\TLanguage, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->tLanguage[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \CountryInfoServiceTest\StructType\TLanguage|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \CountryInfoServiceTest\StructType\TLanguage|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \CountryInfoServiceTest\StructType\TLanguage|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \CountryInfoServiceTest\StructType\TLanguage|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \CountryInfoServiceTest\StructType\TLanguage|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string tLanguage
     */
    public function getAttributeName()
    {
        return 'tLanguage';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \CountryInfoServiceTest\ArrayType\ArrayOftLanguage
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
