<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://webservices.oorsprong.org/websamples.countryinfo/CountryInfoService.wso?wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://webservices.oorsprong.org/websamples.countryinfo/CountryInfoService.wso?wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => \CountryInfoServiceTest\ClassMap::get(),
);
/**
 * Samples for List ServiceType
 */
$list = new \CountryInfoServiceTest\ServiceType\_List($options);
/**
 * Sample call for ListOfContinentsByName operation/method
 */
if ($list->ListOfContinentsByName(new \CountryInfoServiceTest\StructType\ListOfContinentsByName()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for ListOfContinentsByCode operation/method
 */
if ($list->ListOfContinentsByCode(new \CountryInfoServiceTest\StructType\ListOfContinentsByCode()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for ListOfCurrenciesByName operation/method
 */
if ($list->ListOfCurrenciesByName(new \CountryInfoServiceTest\StructType\ListOfCurrenciesByName()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for ListOfCurrenciesByCode operation/method
 */
if ($list->ListOfCurrenciesByCode(new \CountryInfoServiceTest\StructType\ListOfCurrenciesByCode()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for ListOfCountryNamesByCode operation/method
 */
if ($list->ListOfCountryNamesByCode(new \CountryInfoServiceTest\StructType\ListOfCountryNamesByCode()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for ListOfCountryNamesByName operation/method
 */
if ($list->ListOfCountryNamesByName(new \CountryInfoServiceTest\StructType\ListOfCountryNamesByName()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for ListOfCountryNamesGroupedByContinent operation/method
 */
if ($list->ListOfCountryNamesGroupedByContinent(new \CountryInfoServiceTest\StructType\ListOfCountryNamesGroupedByContinent()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for ListOfLanguagesByName operation/method
 */
if ($list->ListOfLanguagesByName(new \CountryInfoServiceTest\StructType\ListOfLanguagesByName()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for ListOfLanguagesByCode operation/method
 */
if ($list->ListOfLanguagesByCode(new \CountryInfoServiceTest\StructType\ListOfLanguagesByCode()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Samples for Currency ServiceType
 */
$currency = new \CountryInfoServiceTest\ServiceType\Currency($options);
/**
 * Sample call for CurrencyName operation/method
 */
if ($currency->CurrencyName(new \CountryInfoServiceTest\StructType\CurrencyName()) !== false) {
    print_r($currency->getResult());
} else {
    print_r($currency->getLastError());
}
/**
 * Samples for Country ServiceType
 */
$country = new \CountryInfoServiceTest\ServiceType\Country($options);
/**
 * Sample call for CountryName operation/method
 */
if ($country->CountryName(new \CountryInfoServiceTest\StructType\CountryName()) !== false) {
    print_r($country->getResult());
} else {
    print_r($country->getLastError());
}
/**
 * Sample call for CountryISOCode operation/method
 */
if ($country->CountryISOCode(new \CountryInfoServiceTest\StructType\CountryISOCode()) !== false) {
    print_r($country->getResult());
} else {
    print_r($country->getLastError());
}
/**
 * Sample call for CountryCurrency operation/method
 */
if ($country->CountryCurrency(new \CountryInfoServiceTest\StructType\CountryCurrency()) !== false) {
    print_r($country->getResult());
} else {
    print_r($country->getLastError());
}
/**
 * Sample call for CountryFlag operation/method
 */
if ($country->CountryFlag(new \CountryInfoServiceTest\StructType\CountryFlag()) !== false) {
    print_r($country->getResult());
} else {
    print_r($country->getLastError());
}
/**
 * Sample call for CountryIntPhoneCode operation/method
 */
if ($country->CountryIntPhoneCode(new \CountryInfoServiceTest\StructType\CountryIntPhoneCode()) !== false) {
    print_r($country->getResult());
} else {
    print_r($country->getLastError());
}
/**
 * Samples for Capital ServiceType
 */
$capital = new \CountryInfoServiceTest\ServiceType\Capital($options);
/**
 * Sample call for CapitalCity operation/method
 */
if ($capital->CapitalCity(new \CountryInfoServiceTest\StructType\CapitalCity()) !== false) {
    print_r($capital->getResult());
} else {
    print_r($capital->getLastError());
}
/**
 * Samples for Full ServiceType
 */
$full = new \CountryInfoServiceTest\ServiceType\Full($options);
/**
 * Sample call for FullCountryInfo operation/method
 */
if ($full->FullCountryInfo(new \CountryInfoServiceTest\StructType\FullCountryInfo()) !== false) {
    print_r($full->getResult());
} else {
    print_r($full->getLastError());
}
/**
 * Sample call for FullCountryInfoAllCountries operation/method
 */
if ($full->FullCountryInfoAllCountries(new \CountryInfoServiceTest\StructType\FullCountryInfoAllCountries()) !== false) {
    print_r($full->getResult());
} else {
    print_r($full->getLastError());
}
/**
 * Samples for Countries ServiceType
 */
$countries = new \CountryInfoServiceTest\ServiceType\Countries($options);
/**
 * Sample call for CountriesUsingCurrency operation/method
 */
if ($countries->CountriesUsingCurrency(new \CountryInfoServiceTest\StructType\CountriesUsingCurrency()) !== false) {
    print_r($countries->getResult());
} else {
    print_r($countries->getLastError());
}
/**
 * Samples for Language ServiceType
 */
$language = new \CountryInfoServiceTest\ServiceType\Language($options);
/**
 * Sample call for LanguageName operation/method
 */
if ($language->LanguageName(new \CountryInfoServiceTest\StructType\LanguageName()) !== false) {
    print_r($language->getResult());
} else {
    print_r($language->getLastError());
}
/**
 * Sample call for LanguageISOCode operation/method
 */
if ($language->LanguageISOCode(new \CountryInfoServiceTest\StructType\LanguageISOCode()) !== false) {
    print_r($language->getResult());
} else {
    print_r($language->getLastError());
}
