<?php

namespace CountryInfoServiceTest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for tLanguage StructType
 * @subpackage Structs
 */
class TLanguage extends AbstractStructBase
{
    /**
     * The sISOCode
     * @var string
     */
    public $sISOCode;
    /**
     * The sName
     * @var string
     */
    public $sName;
    /**
     * Constructor method for tLanguage
     * @uses TLanguage::setSISOCode()
     * @uses TLanguage::setSName()
     * @param string $sISOCode
     * @param string $sName
     */
    public function __construct($sISOCode = null, $sName = null)
    {
        $this
            ->setSISOCode($sISOCode)
            ->setSName($sName);
    }
    /**
     * Get sISOCode value
     * @return string|null
     */
    public function getSISOCode()
    {
        return $this->sISOCode;
    }
    /**
     * Set sISOCode value
     * @param string $sISOCode
     * @return \CountryInfoServiceTest\StructType\TLanguage
     */
    public function setSISOCode($sISOCode = null)
    {
        // validation for constraint: string
        if (!is_null($sISOCode) && !is_string($sISOCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sISOCode, true), gettype($sISOCode)), __LINE__);
        }
        $this->sISOCode = $sISOCode;
        return $this;
    }
    /**
     * Get sName value
     * @return string|null
     */
    public function getSName()
    {
        return $this->sName;
    }
    /**
     * Set sName value
     * @param string $sName
     * @return \CountryInfoServiceTest\StructType\TLanguage
     */
    public function setSName($sName = null)
    {
        // validation for constraint: string
        if (!is_null($sName) && !is_string($sName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sName, true), gettype($sName)), __LINE__);
        }
        $this->sName = $sName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CountryInfoServiceTest\StructType\TLanguage
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
