<?php

namespace CountryInfoServiceTest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for tCountryInfo StructType
 * @subpackage Structs
 */
class TCountryInfo extends AbstractStructBase
{
    /**
     * The sISOCode
     * @var string
     */
    public $sISOCode;
    /**
     * The sName
     * @var string
     */
    public $sName;
    /**
     * The sCapitalCity
     * @var string
     */
    public $sCapitalCity;
    /**
     * The sPhoneCode
     * @var string
     */
    public $sPhoneCode;
    /**
     * The sContinentCode
     * @var string
     */
    public $sContinentCode;
    /**
     * The sCurrencyISOCode
     * @var string
     */
    public $sCurrencyISOCode;
    /**
     * The sCountryFlag
     * @var string
     */
    public $sCountryFlag;
    /**
     * The Languages
     * @var \CountryInfoServiceTest\ArrayType\ArrayOftLanguage
     */
    public $Languages;
    /**
     * Constructor method for tCountryInfo
     * @uses TCountryInfo::setSISOCode()
     * @uses TCountryInfo::setSName()
     * @uses TCountryInfo::setSCapitalCity()
     * @uses TCountryInfo::setSPhoneCode()
     * @uses TCountryInfo::setSContinentCode()
     * @uses TCountryInfo::setSCurrencyISOCode()
     * @uses TCountryInfo::setSCountryFlag()
     * @uses TCountryInfo::setLanguages()
     * @param string $sISOCode
     * @param string $sName
     * @param string $sCapitalCity
     * @param string $sPhoneCode
     * @param string $sContinentCode
     * @param string $sCurrencyISOCode
     * @param string $sCountryFlag
     * @param \CountryInfoServiceTest\ArrayType\ArrayOftLanguage $languages
     */
    public function __construct($sISOCode = null, $sName = null, $sCapitalCity = null, $sPhoneCode = null, $sContinentCode = null, $sCurrencyISOCode = null, $sCountryFlag = null, \CountryInfoServiceTest\ArrayType\ArrayOftLanguage $languages = null)
    {
        $this
            ->setSISOCode($sISOCode)
            ->setSName($sName)
            ->setSCapitalCity($sCapitalCity)
            ->setSPhoneCode($sPhoneCode)
            ->setSContinentCode($sContinentCode)
            ->setSCurrencyISOCode($sCurrencyISOCode)
            ->setSCountryFlag($sCountryFlag)
            ->setLanguages($languages);
    }
    /**
     * Get sISOCode value
     * @return string|null
     */
    public function getSISOCode()
    {
        return $this->sISOCode;
    }
    /**
     * Set sISOCode value
     * @param string $sISOCode
     * @return \CountryInfoServiceTest\StructType\TCountryInfo
     */
    public function setSISOCode($sISOCode = null)
    {
        // validation for constraint: string
        if (!is_null($sISOCode) && !is_string($sISOCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sISOCode, true), gettype($sISOCode)), __LINE__);
        }
        $this->sISOCode = $sISOCode;
        return $this;
    }
    /**
     * Get sName value
     * @return string|null
     */
    public function getSName()
    {
        return $this->sName;
    }
    /**
     * Set sName value
     * @param string $sName
     * @return \CountryInfoServiceTest\StructType\TCountryInfo
     */
    public function setSName($sName = null)
    {
        // validation for constraint: string
        if (!is_null($sName) && !is_string($sName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sName, true), gettype($sName)), __LINE__);
        }
        $this->sName = $sName;
        return $this;
    }
    /**
     * Get sCapitalCity value
     * @return string|null
     */
    public function getSCapitalCity()
    {
        return $this->sCapitalCity;
    }
    /**
     * Set sCapitalCity value
     * @param string $sCapitalCity
     * @return \CountryInfoServiceTest\StructType\TCountryInfo
     */
    public function setSCapitalCity($sCapitalCity = null)
    {
        // validation for constraint: string
        if (!is_null($sCapitalCity) && !is_string($sCapitalCity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sCapitalCity, true), gettype($sCapitalCity)), __LINE__);
        }
        $this->sCapitalCity = $sCapitalCity;
        return $this;
    }
    /**
     * Get sPhoneCode value
     * @return string|null
     */
    public function getSPhoneCode()
    {
        return $this->sPhoneCode;
    }
    /**
     * Set sPhoneCode value
     * @param string $sPhoneCode
     * @return \CountryInfoServiceTest\StructType\TCountryInfo
     */
    public function setSPhoneCode($sPhoneCode = null)
    {
        // validation for constraint: string
        if (!is_null($sPhoneCode) && !is_string($sPhoneCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sPhoneCode, true), gettype($sPhoneCode)), __LINE__);
        }
        $this->sPhoneCode = $sPhoneCode;
        return $this;
    }
    /**
     * Get sContinentCode value
     * @return string|null
     */
    public function getSContinentCode()
    {
        return $this->sContinentCode;
    }
    /**
     * Set sContinentCode value
     * @param string $sContinentCode
     * @return \CountryInfoServiceTest\StructType\TCountryInfo
     */
    public function setSContinentCode($sContinentCode = null)
    {
        // validation for constraint: string
        if (!is_null($sContinentCode) && !is_string($sContinentCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sContinentCode, true), gettype($sContinentCode)), __LINE__);
        }
        $this->sContinentCode = $sContinentCode;
        return $this;
    }
    /**
     * Get sCurrencyISOCode value
     * @return string|null
     */
    public function getSCurrencyISOCode()
    {
        return $this->sCurrencyISOCode;
    }
    /**
     * Set sCurrencyISOCode value
     * @param string $sCurrencyISOCode
     * @return \CountryInfoServiceTest\StructType\TCountryInfo
     */
    public function setSCurrencyISOCode($sCurrencyISOCode = null)
    {
        // validation for constraint: string
        if (!is_null($sCurrencyISOCode) && !is_string($sCurrencyISOCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sCurrencyISOCode, true), gettype($sCurrencyISOCode)), __LINE__);
        }
        $this->sCurrencyISOCode = $sCurrencyISOCode;
        return $this;
    }
    /**
     * Get sCountryFlag value
     * @return string|null
     */
    public function getSCountryFlag()
    {
        return $this->sCountryFlag;
    }
    /**
     * Set sCountryFlag value
     * @param string $sCountryFlag
     * @return \CountryInfoServiceTest\StructType\TCountryInfo
     */
    public function setSCountryFlag($sCountryFlag = null)
    {
        // validation for constraint: string
        if (!is_null($sCountryFlag) && !is_string($sCountryFlag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sCountryFlag, true), gettype($sCountryFlag)), __LINE__);
        }
        $this->sCountryFlag = $sCountryFlag;
        return $this;
    }
    /**
     * Get Languages value
     * @return \CountryInfoServiceTest\ArrayType\ArrayOftLanguage|null
     */
    public function getLanguages()
    {
        return $this->Languages;
    }
    /**
     * Set Languages value
     * @param \CountryInfoServiceTest\ArrayType\ArrayOftLanguage $languages
     * @return \CountryInfoServiceTest\StructType\TCountryInfo
     */
    public function setLanguages(\CountryInfoServiceTest\ArrayType\ArrayOftLanguage $languages = null)
    {
        $this->Languages = $languages;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CountryInfoServiceTest\StructType\TCountryInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
