<?php

namespace CountryInfoServiceTest\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Full ServiceType
 * @subpackage Services
 */
class Full extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named FullCountryInfo
     * Meta information extracted from the WSDL
     * - documentation: Returns a struct with all the stored country information. Pass the ISO country code
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CountryInfoServiceTest\StructType\FullCountryInfo $parameters
     * @return \CountryInfoServiceTest\StructType\FullCountryInfoResponse|bool
     */
    public function FullCountryInfo(\CountryInfoServiceTest\StructType\FullCountryInfo $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->FullCountryInfo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named FullCountryInfoAllCountries
     * Meta information extracted from the WSDL
     * - documentation: Returns an array with all countries and all the language information stored
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CountryInfoServiceTest\StructType\FullCountryInfoAllCountries $parameters
     * @return \CountryInfoServiceTest\StructType\FullCountryInfoAllCountriesResponse|bool
     */
    public function FullCountryInfoAllCountries(\CountryInfoServiceTest\StructType\FullCountryInfoAllCountries $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->FullCountryInfoAllCountries($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \CountryInfoServiceTest\StructType\FullCountryInfoAllCountriesResponse|\CountryInfoServiceTest\StructType\FullCountryInfoResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
