<?php

namespace CountryInfoServiceTest\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Currency ServiceType
 * @subpackage Services
 */
class Currency extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named CurrencyName
     * Meta information extracted from the WSDL
     * - documentation: Returns the name of the currency (if found)
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CountryInfoServiceTest\StructType\CurrencyName $parameters
     * @return \CountryInfoServiceTest\StructType\CurrencyNameResponse|bool
     */
    public function CurrencyName(\CountryInfoServiceTest\StructType\CurrencyName $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CurrencyName($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \CountryInfoServiceTest\StructType\CurrencyNameResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
