<?php

namespace CountryInfoServiceTest\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOftCurrency ArrayType
 * @subpackage Arrays
 */
class ArrayOftCurrency extends AbstractStructArrayBase
{
    /**
     * The tCurrency
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \CountryInfoServiceTest\StructType\TCurrency[]
     */
    public $tCurrency;
    /**
     * Constructor method for ArrayOftCurrency
     * @uses ArrayOftCurrency::setTCurrency()
     * @param \CountryInfoServiceTest\StructType\TCurrency[] $tCurrency
     */
    public function __construct(array $tCurrency = array())
    {
        $this
            ->setTCurrency($tCurrency);
    }
    /**
     * Get tCurrency value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \CountryInfoServiceTest\StructType\TCurrency[]|null
     */
    public function getTCurrency()
    {
        return isset($this->tCurrency) ? $this->tCurrency : null;
    }
    /**
     * This method is responsible for validating the values passed to the setTCurrency method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTCurrency method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTCurrencyForArrayConstraintsFromSetTCurrency(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOftCurrencyTCurrencyItem) {
            // validation for constraint: itemType
            if (!$arrayOftCurrencyTCurrencyItem instanceof \CountryInfoServiceTest\StructType\TCurrency) {
                $invalidValues[] = is_object($arrayOftCurrencyTCurrencyItem) ? get_class($arrayOftCurrencyTCurrencyItem) : sprintf('%s(%s)', gettype($arrayOftCurrencyTCurrencyItem), var_export($arrayOftCurrencyTCurrencyItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The tCurrency property can only contain items of type \CountryInfoServiceTest\StructType\TCurrency, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set tCurrency value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \CountryInfoServiceTest\StructType\TCurrency[] $tCurrency
     * @return \CountryInfoServiceTest\ArrayType\ArrayOftCurrency
     */
    public function setTCurrency(array $tCurrency = array())
    {
        // validation for constraint: array
        if ('' !== ($tCurrencyArrayErrorMessage = self::validateTCurrencyForArrayConstraintsFromSetTCurrency($tCurrency))) {
            throw new \InvalidArgumentException($tCurrencyArrayErrorMessage, __LINE__);
        }
        if (is_null($tCurrency) || (is_array($tCurrency) && empty($tCurrency))) {
            unset($this->tCurrency);
        } else {
            $this->tCurrency = $tCurrency;
        }
        return $this;
    }
    /**
     * Add item to tCurrency value
     * @throws \InvalidArgumentException
     * @param \CountryInfoServiceTest\StructType\TCurrency $item
     * @return \CountryInfoServiceTest\ArrayType\ArrayOftCurrency
     */
    public function addToTCurrency(\CountryInfoServiceTest\StructType\TCurrency $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \CountryInfoServiceTest\StructType\TCurrency) {
            throw new \InvalidArgumentException(sprintf('The tCurrency property can only contain items of type \CountryInfoServiceTest\StructType\TCurrency, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->tCurrency[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \CountryInfoServiceTest\StructType\TCurrency|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \CountryInfoServiceTest\StructType\TCurrency|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \CountryInfoServiceTest\StructType\TCurrency|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \CountryInfoServiceTest\StructType\TCurrency|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \CountryInfoServiceTest\StructType\TCurrency|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string tCurrency
     */
    public function getAttributeName()
    {
        return 'tCurrency';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \CountryInfoServiceTest\ArrayType\ArrayOftCurrency
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
