<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for checkVatResponse StructType
 * @subpackage Structs
 */
class CheckVatResponse extends AbstractStructBase
{
    /**
     * The countryCode
     * @var string
     */
    public $countryCode;
    /**
     * The vatNumber
     * @var string
     */
    public $vatNumber;
    /**
     * The requestDate
     * @var string
     */
    public $requestDate;
    /**
     * The valid
     * @var bool
     */
    public $valid;
    /**
     * The name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $name;
    /**
     * The address
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $address;
    /**
     * Constructor method for checkVatResponse
     * @uses CheckVatResponse::setCountryCode()
     * @uses CheckVatResponse::setVatNumber()
     * @uses CheckVatResponse::setRequestDate()
     * @uses CheckVatResponse::setValid()
     * @uses CheckVatResponse::setName()
     * @uses CheckVatResponse::setAddress()
     * @param string $countryCode
     * @param string $vatNumber
     * @param string $requestDate
     * @param bool $valid
     * @param string $name
     * @param string $address
     */
    public function __construct($countryCode = null, $vatNumber = null, $requestDate = null, $valid = null, $name = null, $address = null)
    {
        $this
            ->setCountryCode($countryCode)
            ->setVatNumber($vatNumber)
            ->setRequestDate($requestDate)
            ->setValid($valid)
            ->setName($name)
            ->setAddress($address);
    }
    /**
     * Get countryCode value
     * @return string|null
     */
    public function getCountryCode()
    {
        return $this->countryCode;
    }
    /**
     * Set countryCode value
     * @param string $countryCode
     * @return \StructType\CheckVatResponse
     */
    public function setCountryCode($countryCode = null)
    {
        // validation for constraint: string
        if (!is_null($countryCode) && !is_string($countryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($countryCode, true), gettype($countryCode)), __LINE__);
        }
        $this->countryCode = $countryCode;
        return $this;
    }
    /**
     * Get vatNumber value
     * @return string|null
     */
    public function getVatNumber()
    {
        return $this->vatNumber;
    }
    /**
     * Set vatNumber value
     * @param string $vatNumber
     * @return \StructType\CheckVatResponse
     */
    public function setVatNumber($vatNumber = null)
    {
        // validation for constraint: string
        if (!is_null($vatNumber) && !is_string($vatNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vatNumber, true), gettype($vatNumber)), __LINE__);
        }
        $this->vatNumber = $vatNumber;
        return $this;
    }
    /**
     * Get requestDate value
     * @return string|null
     */
    public function getRequestDate()
    {
        return $this->requestDate;
    }
    /**
     * Set requestDate value
     * @param string $requestDate
     * @return \StructType\CheckVatResponse
     */
    public function setRequestDate($requestDate = null)
    {
        // validation for constraint: string
        if (!is_null($requestDate) && !is_string($requestDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestDate, true), gettype($requestDate)), __LINE__);
        }
        $this->requestDate = $requestDate;
        return $this;
    }
    /**
     * Get valid value
     * @return bool|null
     */
    public function getValid()
    {
        return $this->valid;
    }
    /**
     * Set valid value
     * @param bool $valid
     * @return \StructType\CheckVatResponse
     */
    public function setValid($valid = null)
    {
        // validation for constraint: boolean
        if (!is_null($valid) && !is_bool($valid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($valid, true), gettype($valid)), __LINE__);
        }
        $this->valid = $valid;
        return $this;
    }
    /**
     * Get name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName()
    {
        return isset($this->name) ? $this->name : null;
    }
    /**
     * Set name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name
     * @return \StructType\CheckVatResponse
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->name);
        } else {
            $this->name = $name;
        }
        return $this;
    }
    /**
     * Get address value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAddress()
    {
        return isset($this->address) ? $this->address : null;
    }
    /**
     * Set address value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $address
     * @return \StructType\CheckVatResponse
     */
    public function setAddress($address = null)
    {
        // validation for constraint: string
        if (!is_null($address) && !is_string($address)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($address, true), gettype($address)), __LINE__);
        }
        if (is_null($address) || (is_array($address) && empty($address))) {
            unset($this->address);
        } else {
            $this->address = $address;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CheckVatResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
