<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for checkVatApproxResponse StructType
 * @subpackage Structs
 */
class CheckVatApproxResponse extends AbstractStructBase
{
    /**
     * The countryCode
     * @var string
     */
    public $countryCode;
    /**
     * The vatNumber
     * @var string
     */
    public $vatNumber;
    /**
     * The requestDate
     * @var string
     */
    public $requestDate;
    /**
     * The valid
     * @var bool
     */
    public $valid;
    /**
     * The traderName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $traderName;
    /**
     * The traderCompanyType
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [A-Z]{2}\-[1-9][0-9]?
     * @var string
     */
    public $traderCompanyType;
    /**
     * The traderAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $traderAddress;
    /**
     * The traderStreet
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $traderStreet;
    /**
     * The traderPostcode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $traderPostcode;
    /**
     * The traderCity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $traderCity;
    /**
     * The traderNameMatch
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $traderNameMatch;
    /**
     * The traderCompanyTypeMatch
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $traderCompanyTypeMatch;
    /**
     * The traderStreetMatch
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $traderStreetMatch;
    /**
     * The traderPostcodeMatch
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $traderPostcodeMatch;
    /**
     * The traderCityMatch
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $traderCityMatch;
    /**
     * The requestIdentifier
     * @var string
     */
    public $requestIdentifier;
    /**
     * Constructor method for checkVatApproxResponse
     * @uses CheckVatApproxResponse::setCountryCode()
     * @uses CheckVatApproxResponse::setVatNumber()
     * @uses CheckVatApproxResponse::setRequestDate()
     * @uses CheckVatApproxResponse::setValid()
     * @uses CheckVatApproxResponse::setTraderName()
     * @uses CheckVatApproxResponse::setTraderCompanyType()
     * @uses CheckVatApproxResponse::setTraderAddress()
     * @uses CheckVatApproxResponse::setTraderStreet()
     * @uses CheckVatApproxResponse::setTraderPostcode()
     * @uses CheckVatApproxResponse::setTraderCity()
     * @uses CheckVatApproxResponse::setTraderNameMatch()
     * @uses CheckVatApproxResponse::setTraderCompanyTypeMatch()
     * @uses CheckVatApproxResponse::setTraderStreetMatch()
     * @uses CheckVatApproxResponse::setTraderPostcodeMatch()
     * @uses CheckVatApproxResponse::setTraderCityMatch()
     * @uses CheckVatApproxResponse::setRequestIdentifier()
     * @param string $countryCode
     * @param string $vatNumber
     * @param string $requestDate
     * @param bool $valid
     * @param string $traderName
     * @param string $traderCompanyType
     * @param string $traderAddress
     * @param string $traderStreet
     * @param string $traderPostcode
     * @param string $traderCity
     * @param string $traderNameMatch
     * @param string $traderCompanyTypeMatch
     * @param string $traderStreetMatch
     * @param string $traderPostcodeMatch
     * @param string $traderCityMatch
     * @param string $requestIdentifier
     */
    public function __construct($countryCode = null, $vatNumber = null, $requestDate = null, $valid = null, $traderName = null, $traderCompanyType = null, $traderAddress = null, $traderStreet = null, $traderPostcode = null, $traderCity = null, $traderNameMatch = null, $traderCompanyTypeMatch = null, $traderStreetMatch = null, $traderPostcodeMatch = null, $traderCityMatch = null, $requestIdentifier = null)
    {
        $this
            ->setCountryCode($countryCode)
            ->setVatNumber($vatNumber)
            ->setRequestDate($requestDate)
            ->setValid($valid)
            ->setTraderName($traderName)
            ->setTraderCompanyType($traderCompanyType)
            ->setTraderAddress($traderAddress)
            ->setTraderStreet($traderStreet)
            ->setTraderPostcode($traderPostcode)
            ->setTraderCity($traderCity)
            ->setTraderNameMatch($traderNameMatch)
            ->setTraderCompanyTypeMatch($traderCompanyTypeMatch)
            ->setTraderStreetMatch($traderStreetMatch)
            ->setTraderPostcodeMatch($traderPostcodeMatch)
            ->setTraderCityMatch($traderCityMatch)
            ->setRequestIdentifier($requestIdentifier);
    }
    /**
     * Get countryCode value
     * @return string|null
     */
    public function getCountryCode()
    {
        return $this->countryCode;
    }
    /**
     * Set countryCode value
     * @param string $countryCode
     * @return \StructType\CheckVatApproxResponse
     */
    public function setCountryCode($countryCode = null)
    {
        // validation for constraint: string
        if (!is_null($countryCode) && !is_string($countryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($countryCode, true), gettype($countryCode)), __LINE__);
        }
        $this->countryCode = $countryCode;
        return $this;
    }
    /**
     * Get vatNumber value
     * @return string|null
     */
    public function getVatNumber()
    {
        return $this->vatNumber;
    }
    /**
     * Set vatNumber value
     * @param string $vatNumber
     * @return \StructType\CheckVatApproxResponse
     */
    public function setVatNumber($vatNumber = null)
    {
        // validation for constraint: string
        if (!is_null($vatNumber) && !is_string($vatNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vatNumber, true), gettype($vatNumber)), __LINE__);
        }
        $this->vatNumber = $vatNumber;
        return $this;
    }
    /**
     * Get requestDate value
     * @return string|null
     */
    public function getRequestDate()
    {
        return $this->requestDate;
    }
    /**
     * Set requestDate value
     * @param string $requestDate
     * @return \StructType\CheckVatApproxResponse
     */
    public function setRequestDate($requestDate = null)
    {
        // validation for constraint: string
        if (!is_null($requestDate) && !is_string($requestDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestDate, true), gettype($requestDate)), __LINE__);
        }
        $this->requestDate = $requestDate;
        return $this;
    }
    /**
     * Get valid value
     * @return bool|null
     */
    public function getValid()
    {
        return $this->valid;
    }
    /**
     * Set valid value
     * @param bool $valid
     * @return \StructType\CheckVatApproxResponse
     */
    public function setValid($valid = null)
    {
        // validation for constraint: boolean
        if (!is_null($valid) && !is_bool($valid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($valid, true), gettype($valid)), __LINE__);
        }
        $this->valid = $valid;
        return $this;
    }
    /**
     * Get traderName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTraderName()
    {
        return isset($this->traderName) ? $this->traderName : null;
    }
    /**
     * Set traderName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $traderName
     * @return \StructType\CheckVatApproxResponse
     */
    public function setTraderName($traderName = null)
    {
        // validation for constraint: string
        if (!is_null($traderName) && !is_string($traderName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($traderName, true), gettype($traderName)), __LINE__);
        }
        if (is_null($traderName) || (is_array($traderName) && empty($traderName))) {
            unset($this->traderName);
        } else {
            $this->traderName = $traderName;
        }
        return $this;
    }
    /**
     * Get traderCompanyType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTraderCompanyType()
    {
        return isset($this->traderCompanyType) ? $this->traderCompanyType : null;
    }
    /**
     * Set traderCompanyType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $traderCompanyType
     * @return \StructType\CheckVatApproxResponse
     */
    public function setTraderCompanyType($traderCompanyType = null)
    {
        // validation for constraint: string
        if (!is_null($traderCompanyType) && !is_string($traderCompanyType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($traderCompanyType, true), gettype($traderCompanyType)), __LINE__);
        }
        // validation for constraint: pattern([A-Z]{2}\-[1-9][0-9]?)
        if (!is_null($traderCompanyType) && !preg_match('/[A-Z]{2}\\-[1-9][0-9]?/', $traderCompanyType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [A-Z]{2}\-[1-9][0-9]?', var_export($traderCompanyType, true)), __LINE__);
        }
        if (is_null($traderCompanyType) || (is_array($traderCompanyType) && empty($traderCompanyType))) {
            unset($this->traderCompanyType);
        } else {
            $this->traderCompanyType = $traderCompanyType;
        }
        return $this;
    }
    /**
     * Get traderAddress value
     * @return string|null
     */
    public function getTraderAddress()
    {
        return $this->traderAddress;
    }
    /**
     * Set traderAddress value
     * @param string $traderAddress
     * @return \StructType\CheckVatApproxResponse
     */
    public function setTraderAddress($traderAddress = null)
    {
        // validation for constraint: string
        if (!is_null($traderAddress) && !is_string($traderAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($traderAddress, true), gettype($traderAddress)), __LINE__);
        }
        $this->traderAddress = $traderAddress;
        return $this;
    }
    /**
     * Get traderStreet value
     * @return string|null
     */
    public function getTraderStreet()
    {
        return $this->traderStreet;
    }
    /**
     * Set traderStreet value
     * @param string $traderStreet
     * @return \StructType\CheckVatApproxResponse
     */
    public function setTraderStreet($traderStreet = null)
    {
        // validation for constraint: string
        if (!is_null($traderStreet) && !is_string($traderStreet)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($traderStreet, true), gettype($traderStreet)), __LINE__);
        }
        $this->traderStreet = $traderStreet;
        return $this;
    }
    /**
     * Get traderPostcode value
     * @return string|null
     */
    public function getTraderPostcode()
    {
        return $this->traderPostcode;
    }
    /**
     * Set traderPostcode value
     * @param string $traderPostcode
     * @return \StructType\CheckVatApproxResponse
     */
    public function setTraderPostcode($traderPostcode = null)
    {
        // validation for constraint: string
        if (!is_null($traderPostcode) && !is_string($traderPostcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($traderPostcode, true), gettype($traderPostcode)), __LINE__);
        }
        $this->traderPostcode = $traderPostcode;
        return $this;
    }
    /**
     * Get traderCity value
     * @return string|null
     */
    public function getTraderCity()
    {
        return $this->traderCity;
    }
    /**
     * Set traderCity value
     * @param string $traderCity
     * @return \StructType\CheckVatApproxResponse
     */
    public function setTraderCity($traderCity = null)
    {
        // validation for constraint: string
        if (!is_null($traderCity) && !is_string($traderCity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($traderCity, true), gettype($traderCity)), __LINE__);
        }
        $this->traderCity = $traderCity;
        return $this;
    }
    /**
     * Get traderNameMatch value
     * @return string|null
     */
    public function getTraderNameMatch()
    {
        return $this->traderNameMatch;
    }
    /**
     * Set traderNameMatch value
     * @uses \EnumType\MatchCode::valueIsValid()
     * @uses \EnumType\MatchCode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $traderNameMatch
     * @return \StructType\CheckVatApproxResponse
     */
    public function setTraderNameMatch($traderNameMatch = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\MatchCode::valueIsValid($traderNameMatch)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\MatchCode', is_array($traderNameMatch) ? implode(', ', $traderNameMatch) : var_export($traderNameMatch, true), implode(', ', \EnumType\MatchCode::getValidValues())), __LINE__);
        }
        $this->traderNameMatch = $traderNameMatch;
        return $this;
    }
    /**
     * Get traderCompanyTypeMatch value
     * @return string|null
     */
    public function getTraderCompanyTypeMatch()
    {
        return $this->traderCompanyTypeMatch;
    }
    /**
     * Set traderCompanyTypeMatch value
     * @uses \EnumType\MatchCode::valueIsValid()
     * @uses \EnumType\MatchCode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $traderCompanyTypeMatch
     * @return \StructType\CheckVatApproxResponse
     */
    public function setTraderCompanyTypeMatch($traderCompanyTypeMatch = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\MatchCode::valueIsValid($traderCompanyTypeMatch)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\MatchCode', is_array($traderCompanyTypeMatch) ? implode(', ', $traderCompanyTypeMatch) : var_export($traderCompanyTypeMatch, true), implode(', ', \EnumType\MatchCode::getValidValues())), __LINE__);
        }
        $this->traderCompanyTypeMatch = $traderCompanyTypeMatch;
        return $this;
    }
    /**
     * Get traderStreetMatch value
     * @return string|null
     */
    public function getTraderStreetMatch()
    {
        return $this->traderStreetMatch;
    }
    /**
     * Set traderStreetMatch value
     * @uses \EnumType\MatchCode::valueIsValid()
     * @uses \EnumType\MatchCode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $traderStreetMatch
     * @return \StructType\CheckVatApproxResponse
     */
    public function setTraderStreetMatch($traderStreetMatch = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\MatchCode::valueIsValid($traderStreetMatch)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\MatchCode', is_array($traderStreetMatch) ? implode(', ', $traderStreetMatch) : var_export($traderStreetMatch, true), implode(', ', \EnumType\MatchCode::getValidValues())), __LINE__);
        }
        $this->traderStreetMatch = $traderStreetMatch;
        return $this;
    }
    /**
     * Get traderPostcodeMatch value
     * @return string|null
     */
    public function getTraderPostcodeMatch()
    {
        return $this->traderPostcodeMatch;
    }
    /**
     * Set traderPostcodeMatch value
     * @uses \EnumType\MatchCode::valueIsValid()
     * @uses \EnumType\MatchCode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $traderPostcodeMatch
     * @return \StructType\CheckVatApproxResponse
     */
    public function setTraderPostcodeMatch($traderPostcodeMatch = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\MatchCode::valueIsValid($traderPostcodeMatch)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\MatchCode', is_array($traderPostcodeMatch) ? implode(', ', $traderPostcodeMatch) : var_export($traderPostcodeMatch, true), implode(', ', \EnumType\MatchCode::getValidValues())), __LINE__);
        }
        $this->traderPostcodeMatch = $traderPostcodeMatch;
        return $this;
    }
    /**
     * Get traderCityMatch value
     * @return string|null
     */
    public function getTraderCityMatch()
    {
        return $this->traderCityMatch;
    }
    /**
     * Set traderCityMatch value
     * @uses \EnumType\MatchCode::valueIsValid()
     * @uses \EnumType\MatchCode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $traderCityMatch
     * @return \StructType\CheckVatApproxResponse
     */
    public function setTraderCityMatch($traderCityMatch = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\MatchCode::valueIsValid($traderCityMatch)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\MatchCode', is_array($traderCityMatch) ? implode(', ', $traderCityMatch) : var_export($traderCityMatch, true), implode(', ', \EnumType\MatchCode::getValidValues())), __LINE__);
        }
        $this->traderCityMatch = $traderCityMatch;
        return $this;
    }
    /**
     * Get requestIdentifier value
     * @return string|null
     */
    public function getRequestIdentifier()
    {
        return $this->requestIdentifier;
    }
    /**
     * Set requestIdentifier value
     * @param string $requestIdentifier
     * @return \StructType\CheckVatApproxResponse
     */
    public function setRequestIdentifier($requestIdentifier = null)
    {
        // validation for constraint: string
        if (!is_null($requestIdentifier) && !is_string($requestIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestIdentifier, true), gettype($requestIdentifier)), __LINE__);
        }
        $this->requestIdentifier = $requestIdentifier;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CheckVatApproxResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
