<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Door StructType
 * @subpackage Structs
 */
class Door extends AbstractStructBase
{
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - base: int
     * - maxInclusive: 65535
     * @var int
     */
    public $Id;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 200
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 200
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The SiteId
     * Meta information extracted from the WSDL
     * - base: int
     * - maxInclusive: 65535
     * @var int
     */
    public $SiteId;
    /**
     * Constructor method for Door
     * @uses Door::setId()
     * @uses Door::setName()
     * @uses Door::setDescription()
     * @uses Door::setSiteId()
     * @param int $id
     * @param string $name
     * @param string $description
     * @param int $siteId
     */
    public function __construct($id = null, $name = null, $description = null, $siteId = null)
    {
        $this
            ->setId($id)
            ->setName($name)
            ->setDescription($description)
            ->setSiteId($siteId);
    }
    /**
     * Get Id value
     * @return int|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param int $id
     * @return \StructType\Door
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !(is_int($id) || ctype_digit($id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        // validation for constraint: maxInclusive(65535)
        if (!is_null($id) && $id > 65535) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 65535', var_export($id, true)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\Door
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        // validation for constraint: maxLength(200)
        if (!is_null($name) && mb_strlen($name) > 200) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 200', mb_strlen($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\Door
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        // validation for constraint: maxLength(200)
        if (!is_null($description) && mb_strlen($description) > 200) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 200', mb_strlen($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get SiteId value
     * @return int|null
     */
    public function getSiteId()
    {
        return $this->SiteId;
    }
    /**
     * Set SiteId value
     * @param int $siteId
     * @return \StructType\Door
     */
    public function setSiteId($siteId = null)
    {
        // validation for constraint: int
        if (!is_null($siteId) && !(is_int($siteId) || ctype_digit($siteId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($siteId, true), gettype($siteId)), __LINE__);
        }
        // validation for constraint: maxInclusive(65535)
        if (!is_null($siteId) && $siteId > 65535) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 65535', var_export($siteId, true)), __LINE__);
        }
        $this->SiteId = $siteId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Door
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
