<?php
/**
 * Class which returns the class map definition
 * @package
 */
class ClassMap
{
    /**
     * Returns the mapping between the WSDL Structs and generated Structs' classes
     * This array is sent to the \SoapClient when calling the WS
     * @return string[]
     */
    final public static function get()
    {
        return array(
            'Status' => '\\StructType\\Status',
            'DoorSearch' => '\\StructType\\DoorSearch',
            'DoorResult' => '\\StructType\\DoorResult',
            'DoorList' => '\\StructType\\DoorList',
            'DoorGroupSearch' => '\\StructType\\DoorGroupSearch',
            'DoorGroupResult' => '\\StructType\\DoorGroupResult',
            'DoorGroupList' => '\\StructType\\DoorGroupList',
            'SiteSearch' => '\\StructType\\SiteSearch',
            'SiteResult' => '\\StructType\\SiteResult',
            'SiteList' => '\\StructType\\SiteList',
            'ConfigurationSearch' => '\\StructType\\ConfigurationSearch',
            'ConfigurationResult' => '\\StructType\\ConfigurationResult',
            'Configuration' => '\\StructType\\Configuration',
            'ErrorInfo' => '\\StructType\\ErrorInfo',
            'Door' => '\\StructType\\Door',
            'DoorSearchData' => '\\StructType\\DoorSearchData',
            'DoorGroup' => '\\StructType\\DoorGroup',
            'DoorGroupSearchData' => '\\StructType\\DoorGroupSearchData',
            'Site' => '\\StructType\\Site',
            'SiteSearchData' => '\\StructType\\SiteSearchData',
            'SearchRange' => '\\StructType\\SearchRange',
        );
    }
}
