<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DoorList StructType
 * @subpackage Structs
 */
class DoorList extends AbstractStructBase
{
    /**
     * The Error
     * Meta information extracted from the WSDL
     * - choice: Error | Door
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\ErrorInfo
     */
    public $Error;
    /**
     * The Door
     * Meta information extracted from the WSDL
     * - choice: Error | Door
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Door[]
     */
    public $Door;
    /**
     * The DoorId
     * Meta information extracted from the WSDL
     * - base: int
     * - maxInclusive: 65535
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var int[]
     */
    public $DoorId;
    /**
     * Constructor method for DoorList
     * @uses DoorList::setError()
     * @uses DoorList::setDoor()
     * @uses DoorList::setDoorId()
     * @param \StructType\ErrorInfo $error
     * @param \StructType\Door[] $door
     * @param int[] $doorId
     */
    public function __construct(\StructType\ErrorInfo $error = null, array $door = array(), array $doorId = array())
    {
        $this
            ->setError($error)
            ->setDoor($door)
            ->setDoorId($doorId);
    }
    /**
     * Get Error value
     * @return \StructType\ErrorInfo|null
     */
    public function getError()
    {
        return isset($this->Error) ? $this->Error : null;
    }
    /**
     * This method is responsible for validating the value passed to the setError method
     * This method is willingly generated in order to preserve the one-line inline validation within the setError method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateErrorForChoiceConstraintsFromSetError($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Door',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Error can\'t be set as the property %s is already set. Only one property must be set among these properties: Error, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Error value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ErrorInfo $error
     * @return \StructType\DoorList
     */
    public function setError(\StructType\ErrorInfo $error = null)
    {
        // validation for constraint: choice(Error, Door)
        if ('' !== ($errorChoiceErrorMessage = self::validateErrorForChoiceConstraintsFromSetError($error))) {
            throw new \InvalidArgumentException($errorChoiceErrorMessage, __LINE__);
        }
        if (is_null($error) || (is_array($error) && empty($error))) {
            unset($this->Error);
        } else {
            $this->Error = $error;
        }
        return $this;
    }
    /**
     * Get Door value
     * @return \StructType\Door[]|null
     */
    public function getDoor()
    {
        return isset($this->Door) ? $this->Door : null;
    }
    /**
     * This method is responsible for validating the values passed to the setDoor method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDoor method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDoorForArrayConstraintsFromSetDoor(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $doorListDoorItem) {
            // validation for constraint: itemType
            if (!$doorListDoorItem instanceof \StructType\Door) {
                $invalidValues[] = is_object($doorListDoorItem) ? get_class($doorListDoorItem) : sprintf('%s(%s)', gettype($doorListDoorItem), var_export($doorListDoorItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Door property can only contain items of type \StructType\Door, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setDoor method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDoor method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateDoorForChoiceConstraintsFromSetDoor($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Error',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Door can\'t be set as the property %s is already set. Only one property must be set among these properties: Door, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Door value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @throws \InvalidArgumentException
     * @param \StructType\Door[] $door
     * @return \StructType\DoorList
     */
    public function setDoor(array $door = array())
    {
        // validation for constraint: array
        if ('' !== ($doorArrayErrorMessage = self::validateDoorForArrayConstraintsFromSetDoor($door))) {
            throw new \InvalidArgumentException($doorArrayErrorMessage, __LINE__);
        }
        // validation for constraint: choice(Error, Door)
        if ('' !== ($doorChoiceErrorMessage = self::validateDoorForChoiceConstraintsFromSetDoor($door))) {
            throw new \InvalidArgumentException($doorChoiceErrorMessage, __LINE__);
        }
        if (is_null($door) || (is_array($door) && empty($door))) {
            unset($this->Door);
        } else {
            $this->Door = $door;
        }
        return $this;
    }
    /**
     * This method is responsible for validating the value passed to the addToDoor method
     * This method is willingly generated in order to preserve the one-line inline validation within the addToDoor method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateItemForChoiceConstraintsFromAddToDoor($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Error',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Door can\'t be set as the property %s is already set. Only one property must be set among these properties: Door, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Add item to Door value
     * @throws \InvalidArgumentException
     * @param \StructType\Door $item
     * @return \StructType\DoorList
     */
    public function addToDoor(\StructType\Door $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Door) {
            throw new \InvalidArgumentException(sprintf('The Door property can only contain items of type \StructType\Door, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: choice(Error, Door)
        if ('' !== ($itemChoiceErrorMessage = self::validateItemForChoiceConstraintsFromAddToDoor($item))) {
            throw new \InvalidArgumentException($itemChoiceErrorMessage, __LINE__);
        }
        $this->Door[] = $item;
        return $this;
    }
    /**
     * Get DoorId value
     * @return int[]|null
     */
    public function getDoorId()
    {
        return $this->DoorId;
    }
    /**
     * This method is responsible for validating the values passed to the setDoorId method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDoorId method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDoorIdForArrayConstraintsFromSetDoorId(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $doorListDoorIdItem) {
            // validation for constraint: itemType
            if (!(is_int($doorListDoorIdItem) || ctype_digit($doorListDoorIdItem))) {
                $invalidValues[] = is_object($doorListDoorIdItem) ? get_class($doorListDoorIdItem) : sprintf('%s(%s)', gettype($doorListDoorIdItem), var_export($doorListDoorIdItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The DoorId property can only contain items of type int, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set DoorId value
     * @throws \InvalidArgumentException
     * @param int[] $doorId
     * @return \StructType\DoorList
     */
    public function setDoorId(array $doorId = array())
    {
        // validation for constraint: array
        if ('' !== ($doorIdArrayErrorMessage = self::validateDoorIdForArrayConstraintsFromSetDoorId($doorId))) {
            throw new \InvalidArgumentException($doorIdArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxInclusive(65535)
        if (!is_null($doorId) && $doorId > 65535) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 65535', var_export($doorId, true)), __LINE__);
        }
        $this->DoorId = $doorId;
        return $this;
    }
    /**
     * Add item to DoorId value
     * @throws \InvalidArgumentException
     * @param int $item
     * @return \StructType\DoorList
     */
    public function addToDoorId($item)
    {
        // validation for constraint: itemType
        if (!(is_int($item) || ctype_digit($item))) {
            throw new \InvalidArgumentException(sprintf('The DoorId property can only contain items of type int, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxInclusive(65535)
        if ($item > 65535) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 65535', var_export($item, true)), __LINE__);
        }
        $this->DoorId[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DoorList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
