<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ConfigurationResult StructType
 * @subpackage Structs
 */
class ConfigurationResult extends AbstractStructBase
{
    /**
     * The Error
     * Meta information extracted from the WSDL
     * - choice: Error | Configuration
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\ErrorInfo
     */
    public $Error;
    /**
     * The Configuration
     * Meta information extracted from the WSDL
     * - choice: Error | Configuration
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Configuration[]
     */
    public $Configuration;
    /**
     * Constructor method for ConfigurationResult
     * @uses ConfigurationResult::setError()
     * @uses ConfigurationResult::setConfiguration()
     * @param \StructType\ErrorInfo $error
     * @param \StructType\Configuration[] $configuration
     */
    public function __construct(\StructType\ErrorInfo $error = null, array $configuration = array())
    {
        $this
            ->setError($error)
            ->setConfiguration($configuration);
    }
    /**
     * Get Error value
     * @return \StructType\ErrorInfo|null
     */
    public function getError()
    {
        return isset($this->Error) ? $this->Error : null;
    }
    /**
     * This method is responsible for validating the value passed to the setError method
     * This method is willingly generated in order to preserve the one-line inline validation within the setError method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateErrorForChoiceConstraintsFromSetError($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Configuration',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Error can\'t be set as the property %s is already set. Only one property must be set among these properties: Error, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Error value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ErrorInfo $error
     * @return \StructType\ConfigurationResult
     */
    public function setError(\StructType\ErrorInfo $error = null)
    {
        // validation for constraint: choice(Error, Configuration)
        if ('' !== ($errorChoiceErrorMessage = self::validateErrorForChoiceConstraintsFromSetError($error))) {
            throw new \InvalidArgumentException($errorChoiceErrorMessage, __LINE__);
        }
        if (is_null($error) || (is_array($error) && empty($error))) {
            unset($this->Error);
        } else {
            $this->Error = $error;
        }
        return $this;
    }
    /**
     * Get Configuration value
     * @return \StructType\Configuration[]|null
     */
    public function getConfiguration()
    {
        return isset($this->Configuration) ? $this->Configuration : null;
    }
    /**
     * This method is responsible for validating the values passed to the setConfiguration method
     * This method is willingly generated in order to preserve the one-line inline validation within the setConfiguration method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateConfigurationForArrayConstraintsFromSetConfiguration(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $configurationResultConfigurationItem) {
            // validation for constraint: itemType
            if (!$configurationResultConfigurationItem instanceof \StructType\Configuration) {
                $invalidValues[] = is_object($configurationResultConfigurationItem) ? get_class($configurationResultConfigurationItem) : sprintf('%s(%s)', gettype($configurationResultConfigurationItem), var_export($configurationResultConfigurationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Configuration property can only contain items of type \StructType\Configuration, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setConfiguration method
     * This method is willingly generated in order to preserve the one-line inline validation within the setConfiguration method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateConfigurationForChoiceConstraintsFromSetConfiguration($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Error',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Configuration can\'t be set as the property %s is already set. Only one property must be set among these properties: Configuration, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Configuration value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @throws \InvalidArgumentException
     * @param \StructType\Configuration[] $configuration
     * @return \StructType\ConfigurationResult
     */
    public function setConfiguration(array $configuration = array())
    {
        // validation for constraint: array
        if ('' !== ($configurationArrayErrorMessage = self::validateConfigurationForArrayConstraintsFromSetConfiguration($configuration))) {
            throw new \InvalidArgumentException($configurationArrayErrorMessage, __LINE__);
        }
        // validation for constraint: choice(Error, Configuration)
        if ('' !== ($configurationChoiceErrorMessage = self::validateConfigurationForChoiceConstraintsFromSetConfiguration($configuration))) {
            throw new \InvalidArgumentException($configurationChoiceErrorMessage, __LINE__);
        }
        if (is_null($configuration) || (is_array($configuration) && empty($configuration))) {
            unset($this->Configuration);
        } else {
            $this->Configuration = $configuration;
        }
        return $this;
    }
    /**
     * This method is responsible for validating the value passed to the addToConfiguration method
     * This method is willingly generated in order to preserve the one-line inline validation within the addToConfiguration method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateItemForChoiceConstraintsFromAddToConfiguration($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Error',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Configuration can\'t be set as the property %s is already set. Only one property must be set among these properties: Configuration, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Add item to Configuration value
     * @throws \InvalidArgumentException
     * @param \StructType\Configuration $item
     * @return \StructType\ConfigurationResult
     */
    public function addToConfiguration(\StructType\Configuration $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Configuration) {
            throw new \InvalidArgumentException(sprintf('The Configuration property can only contain items of type \StructType\Configuration, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: choice(Error, Configuration)
        if ('' !== ($itemChoiceErrorMessage = self::validateItemForChoiceConstraintsFromAddToConfiguration($item))) {
            throw new \InvalidArgumentException($itemChoiceErrorMessage, __LINE__);
        }
        $this->Configuration[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ConfigurationResult
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
