<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Configuration StructType
 * @subpackage Structs
 */
class Configuration extends AbstractStructBase
{
    /**
     * The Site
     * @var \StructType\Site
     */
    public $Site;
    /**
     * The Door
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Door[]
     */
    public $Door;
    /**
     * The DoorGroup
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\DoorGroup[]
     */
    public $DoorGroup;
    /**
     * Constructor method for Configuration
     * @uses Configuration::setSite()
     * @uses Configuration::setDoor()
     * @uses Configuration::setDoorGroup()
     * @param \StructType\Site $site
     * @param \StructType\Door[] $door
     * @param \StructType\DoorGroup[] $doorGroup
     */
    public function __construct(\StructType\Site $site = null, array $door = array(), array $doorGroup = array())
    {
        $this
            ->setSite($site)
            ->setDoor($door)
            ->setDoorGroup($doorGroup);
    }
    /**
     * Get Site value
     * @return \StructType\Site|null
     */
    public function getSite()
    {
        return $this->Site;
    }
    /**
     * Set Site value
     * @param \StructType\Site $site
     * @return \StructType\Configuration
     */
    public function setSite(\StructType\Site $site = null)
    {
        $this->Site = $site;
        return $this;
    }
    /**
     * Get Door value
     * @return \StructType\Door[]|null
     */
    public function getDoor()
    {
        return $this->Door;
    }
    /**
     * This method is responsible for validating the values passed to the setDoor method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDoor method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDoorForArrayConstraintsFromSetDoor(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $configurationDoorItem) {
            // validation for constraint: itemType
            if (!$configurationDoorItem instanceof \StructType\Door) {
                $invalidValues[] = is_object($configurationDoorItem) ? get_class($configurationDoorItem) : sprintf('%s(%s)', gettype($configurationDoorItem), var_export($configurationDoorItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Door property can only contain items of type \StructType\Door, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Door value
     * @throws \InvalidArgumentException
     * @param \StructType\Door[] $door
     * @return \StructType\Configuration
     */
    public function setDoor(array $door = array())
    {
        // validation for constraint: array
        if ('' !== ($doorArrayErrorMessage = self::validateDoorForArrayConstraintsFromSetDoor($door))) {
            throw new \InvalidArgumentException($doorArrayErrorMessage, __LINE__);
        }
        $this->Door = $door;
        return $this;
    }
    /**
     * Add item to Door value
     * @throws \InvalidArgumentException
     * @param \StructType\Door $item
     * @return \StructType\Configuration
     */
    public function addToDoor(\StructType\Door $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Door) {
            throw new \InvalidArgumentException(sprintf('The Door property can only contain items of type \StructType\Door, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Door[] = $item;
        return $this;
    }
    /**
     * Get DoorGroup value
     * @return \StructType\DoorGroup[]|null
     */
    public function getDoorGroup()
    {
        return $this->DoorGroup;
    }
    /**
     * This method is responsible for validating the values passed to the setDoorGroup method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDoorGroup method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDoorGroupForArrayConstraintsFromSetDoorGroup(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $configurationDoorGroupItem) {
            // validation for constraint: itemType
            if (!$configurationDoorGroupItem instanceof \StructType\DoorGroup) {
                $invalidValues[] = is_object($configurationDoorGroupItem) ? get_class($configurationDoorGroupItem) : sprintf('%s(%s)', gettype($configurationDoorGroupItem), var_export($configurationDoorGroupItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The DoorGroup property can only contain items of type \StructType\DoorGroup, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set DoorGroup value
     * @throws \InvalidArgumentException
     * @param \StructType\DoorGroup[] $doorGroup
     * @return \StructType\Configuration
     */
    public function setDoorGroup(array $doorGroup = array())
    {
        // validation for constraint: array
        if ('' !== ($doorGroupArrayErrorMessage = self::validateDoorGroupForArrayConstraintsFromSetDoorGroup($doorGroup))) {
            throw new \InvalidArgumentException($doorGroupArrayErrorMessage, __LINE__);
        }
        $this->DoorGroup = $doorGroup;
        return $this;
    }
    /**
     * Add item to DoorGroup value
     * @throws \InvalidArgumentException
     * @param \StructType\DoorGroup $item
     * @return \StructType\Configuration
     */
    public function addToDoorGroup(\StructType\DoorGroup $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DoorGroup) {
            throw new \InvalidArgumentException(sprintf('The DoorGroup property can only contain items of type \StructType\DoorGroup, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->DoorGroup[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Configuration
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
