<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateEnterpriseGroupInput StructType
 * @subpackage Structs
 */
class UpdateEnterpriseGroupInput extends AbstractStructBase
{
    /**
     * The CustomerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CustomerId;
    /**
     * The SystemGroupId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $SystemGroupId;
    /**
     * The RetainAccess
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $RetainAccess;
    /**
     * The NewSystemGroupId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $NewSystemGroupId;
    /**
     * Constructor method for UpdateEnterpriseGroupInput
     * @uses UpdateEnterpriseGroupInput::setCustomerId()
     * @uses UpdateEnterpriseGroupInput::setSystemGroupId()
     * @uses UpdateEnterpriseGroupInput::setRetainAccess()
     * @uses UpdateEnterpriseGroupInput::setNewSystemGroupId()
     * @param int $customerId
     * @param int $systemGroupId
     * @param bool $retainAccess
     * @param int $newSystemGroupId
     */
    public function __construct($customerId = null, $systemGroupId = null, $retainAccess = null, $newSystemGroupId = null)
    {
        $this
            ->setCustomerId($customerId)
            ->setSystemGroupId($systemGroupId)
            ->setRetainAccess($retainAccess)
            ->setNewSystemGroupId($newSystemGroupId);
    }
    /**
     * Get CustomerId value
     * @return int
     */
    public function getCustomerId()
    {
        return $this->CustomerId;
    }
    /**
     * Set CustomerId value
     * @param int $customerId
     * @return \CustomerManagement\StructType\UpdateEnterpriseGroupInput
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: int
        if (!is_null($customerId) && !(is_int($customerId) || ctype_digit($customerId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($customerId, true), gettype($customerId)), __LINE__);
        }
        $this->CustomerId = $customerId;
        return $this;
    }
    /**
     * Get SystemGroupId value
     * @return int
     */
    public function getSystemGroupId()
    {
        return $this->SystemGroupId;
    }
    /**
     * Set SystemGroupId value
     * @param int $systemGroupId
     * @return \CustomerManagement\StructType\UpdateEnterpriseGroupInput
     */
    public function setSystemGroupId($systemGroupId = null)
    {
        // validation for constraint: int
        if (!is_null($systemGroupId) && !(is_int($systemGroupId) || ctype_digit($systemGroupId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($systemGroupId, true), gettype($systemGroupId)), __LINE__);
        }
        $this->SystemGroupId = $systemGroupId;
        return $this;
    }
    /**
     * Get RetainAccess value
     * @return bool
     */
    public function getRetainAccess()
    {
        return $this->RetainAccess;
    }
    /**
     * Set RetainAccess value
     * @param bool $retainAccess
     * @return \CustomerManagement\StructType\UpdateEnterpriseGroupInput
     */
    public function setRetainAccess($retainAccess = null)
    {
        // validation for constraint: boolean
        if (!is_null($retainAccess) && !is_bool($retainAccess)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($retainAccess, true), gettype($retainAccess)), __LINE__);
        }
        $this->RetainAccess = $retainAccess;
        return $this;
    }
    /**
     * Get NewSystemGroupId value
     * @return int
     */
    public function getNewSystemGroupId()
    {
        return $this->NewSystemGroupId;
    }
    /**
     * Set NewSystemGroupId value
     * @param int $newSystemGroupId
     * @return \CustomerManagement\StructType\UpdateEnterpriseGroupInput
     */
    public function setNewSystemGroupId($newSystemGroupId = null)
    {
        // validation for constraint: int
        if (!is_null($newSystemGroupId) && !(is_int($newSystemGroupId) || ctype_digit($newSystemGroupId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($newSystemGroupId, true), gettype($newSystemGroupId)), __LINE__);
        }
        $this->NewSystemGroupId = $newSystemGroupId;
        return $this;
    }
}
