<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetImageSensorInfoOutput StructType
 * @subpackage Structs
 */
class GetImageSensorInfoOutput extends AbstractStructBase
{
    /**
     * The Success
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Success;
    /**
     * The ErrorMessage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ErrorMessage;
    /**
     * The ImageSensorInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CustomerManagement\StructType\ImageSensorInfo
     */
    public $ImageSensorInfo;
    /**
     * Constructor method for GetImageSensorInfoOutput
     * @uses GetImageSensorInfoOutput::setSuccess()
     * @uses GetImageSensorInfoOutput::setErrorMessage()
     * @uses GetImageSensorInfoOutput::setImageSensorInfo()
     * @param bool $success
     * @param string $errorMessage
     * @param \CustomerManagement\StructType\ImageSensorInfo $imageSensorInfo
     */
    public function __construct($success = null, $errorMessage = null, \CustomerManagement\StructType\ImageSensorInfo $imageSensorInfo = null)
    {
        $this
            ->setSuccess($success)
            ->setErrorMessage($errorMessage)
            ->setImageSensorInfo($imageSensorInfo);
    }
    /**
     * Get Success value
     * @return bool
     */
    public function getSuccess()
    {
        return $this->Success;
    }
    /**
     * Set Success value
     * @param bool $success
     * @return \CustomerManagement\StructType\GetImageSensorInfoOutput
     */
    public function setSuccess($success = null)
    {
        // validation for constraint: boolean
        if (!is_null($success) && !is_bool($success)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($success, true), gettype($success)), __LINE__);
        }
        $this->Success = $success;
        return $this;
    }
    /**
     * Get ErrorMessage value
     * @return string|null
     */
    public function getErrorMessage()
    {
        return $this->ErrorMessage;
    }
    /**
     * Set ErrorMessage value
     * @param string $errorMessage
     * @return \CustomerManagement\StructType\GetImageSensorInfoOutput
     */
    public function setErrorMessage($errorMessage = null)
    {
        // validation for constraint: string
        if (!is_null($errorMessage) && !is_string($errorMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorMessage, true), gettype($errorMessage)), __LINE__);
        }
        $this->ErrorMessage = $errorMessage;
        return $this;
    }
    /**
     * Get ImageSensorInfo value
     * @return \CustomerManagement\StructType\ImageSensorInfo|null
     */
    public function getImageSensorInfo()
    {
        return $this->ImageSensorInfo;
    }
    /**
     * Set ImageSensorInfo value
     * @param \CustomerManagement\StructType\ImageSensorInfo $imageSensorInfo
     * @return \CustomerManagement\StructType\GetImageSensorInfoOutput
     */
    public function setImageSensorInfo(\CustomerManagement\StructType\ImageSensorInfo $imageSensorInfo = null)
    {
        $this->ImageSensorInfo = $imageSensorInfo;
        return $this;
    }
}
