<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CellSignalingSummaryOutput StructType
 * @subpackage Structs
 */
class CellSignalingSummaryOutput extends AbstractStructBase
{
    /**
     * The RegistrationEvents
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $RegistrationEvents;
    /**
     * The MessagesDelayed
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $MessagesDelayed;
    /**
     * The PercentageOfTimePanelNotResponding
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $PercentageOfTimePanelNotResponding;
    /**
     * The LastCellPing
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $LastCellPing;
    /**
     * The Rating
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Rating;
    /**
     * The SignalStrengthBars
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CustomerManagement\StructType\SignalStrengthOutput
     */
    public $SignalStrengthBars;
    /**
     * The SignalStrengthInternal
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CustomerManagement\StructType\SignalStrengthOutput
     */
    public $SignalStrengthInternal;
    /**
     * Constructor method for CellSignalingSummaryOutput
     * @uses CellSignalingSummaryOutput::setRegistrationEvents()
     * @uses CellSignalingSummaryOutput::setMessagesDelayed()
     * @uses CellSignalingSummaryOutput::setPercentageOfTimePanelNotResponding()
     * @uses CellSignalingSummaryOutput::setLastCellPing()
     * @uses CellSignalingSummaryOutput::setRating()
     * @uses CellSignalingSummaryOutput::setSignalStrengthBars()
     * @uses CellSignalingSummaryOutput::setSignalStrengthInternal()
     * @param int $registrationEvents
     * @param int $messagesDelayed
     * @param float $percentageOfTimePanelNotResponding
     * @param string $lastCellPing
     * @param string $rating
     * @param \CustomerManagement\StructType\SignalStrengthOutput $signalStrengthBars
     * @param \CustomerManagement\StructType\SignalStrengthOutput $signalStrengthInternal
     */
    public function __construct($registrationEvents = null, $messagesDelayed = null, $percentageOfTimePanelNotResponding = null, $lastCellPing = null, $rating = null, \CustomerManagement\StructType\SignalStrengthOutput $signalStrengthBars = null, \CustomerManagement\StructType\SignalStrengthOutput $signalStrengthInternal = null)
    {
        $this
            ->setRegistrationEvents($registrationEvents)
            ->setMessagesDelayed($messagesDelayed)
            ->setPercentageOfTimePanelNotResponding($percentageOfTimePanelNotResponding)
            ->setLastCellPing($lastCellPing)
            ->setRating($rating)
            ->setSignalStrengthBars($signalStrengthBars)
            ->setSignalStrengthInternal($signalStrengthInternal);
    }
    /**
     * Get RegistrationEvents value
     * @return int
     */
    public function getRegistrationEvents()
    {
        return $this->RegistrationEvents;
    }
    /**
     * Set RegistrationEvents value
     * @param int $registrationEvents
     * @return \CustomerManagement\StructType\CellSignalingSummaryOutput
     */
    public function setRegistrationEvents($registrationEvents = null)
    {
        // validation for constraint: int
        if (!is_null($registrationEvents) && !(is_int($registrationEvents) || ctype_digit($registrationEvents))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($registrationEvents, true), gettype($registrationEvents)), __LINE__);
        }
        $this->RegistrationEvents = $registrationEvents;
        return $this;
    }
    /**
     * Get MessagesDelayed value
     * @return int
     */
    public function getMessagesDelayed()
    {
        return $this->MessagesDelayed;
    }
    /**
     * Set MessagesDelayed value
     * @param int $messagesDelayed
     * @return \CustomerManagement\StructType\CellSignalingSummaryOutput
     */
    public function setMessagesDelayed($messagesDelayed = null)
    {
        // validation for constraint: int
        if (!is_null($messagesDelayed) && !(is_int($messagesDelayed) || ctype_digit($messagesDelayed))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($messagesDelayed, true), gettype($messagesDelayed)), __LINE__);
        }
        $this->MessagesDelayed = $messagesDelayed;
        return $this;
    }
    /**
     * Get PercentageOfTimePanelNotResponding value
     * @return float
     */
    public function getPercentageOfTimePanelNotResponding()
    {
        return $this->PercentageOfTimePanelNotResponding;
    }
    /**
     * Set PercentageOfTimePanelNotResponding value
     * @param float $percentageOfTimePanelNotResponding
     * @return \CustomerManagement\StructType\CellSignalingSummaryOutput
     */
    public function setPercentageOfTimePanelNotResponding($percentageOfTimePanelNotResponding = null)
    {
        // validation for constraint: float
        if (!is_null($percentageOfTimePanelNotResponding) && !(is_float($percentageOfTimePanelNotResponding) || is_numeric($percentageOfTimePanelNotResponding))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($percentageOfTimePanelNotResponding, true), gettype($percentageOfTimePanelNotResponding)), __LINE__);
        }
        $this->PercentageOfTimePanelNotResponding = $percentageOfTimePanelNotResponding;
        return $this;
    }
    /**
     * Get LastCellPing value
     * @return string
     */
    public function getLastCellPing()
    {
        return $this->LastCellPing;
    }
    /**
     * Set LastCellPing value
     * @param string $lastCellPing
     * @return \CustomerManagement\StructType\CellSignalingSummaryOutput
     */
    public function setLastCellPing($lastCellPing = null)
    {
        // validation for constraint: string
        if (!is_null($lastCellPing) && !is_string($lastCellPing)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastCellPing, true), gettype($lastCellPing)), __LINE__);
        }
        $this->LastCellPing = $lastCellPing;
        return $this;
    }
    /**
     * Get Rating value
     * @return string|null
     */
    public function getRating()
    {
        return $this->Rating;
    }
    /**
     * Set Rating value
     * @param string $rating
     * @return \CustomerManagement\StructType\CellSignalingSummaryOutput
     */
    public function setRating($rating = null)
    {
        // validation for constraint: string
        if (!is_null($rating) && !is_string($rating)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rating, true), gettype($rating)), __LINE__);
        }
        $this->Rating = $rating;
        return $this;
    }
    /**
     * Get SignalStrengthBars value
     * @return \CustomerManagement\StructType\SignalStrengthOutput|null
     */
    public function getSignalStrengthBars()
    {
        return $this->SignalStrengthBars;
    }
    /**
     * Set SignalStrengthBars value
     * @param \CustomerManagement\StructType\SignalStrengthOutput $signalStrengthBars
     * @return \CustomerManagement\StructType\CellSignalingSummaryOutput
     */
    public function setSignalStrengthBars(\CustomerManagement\StructType\SignalStrengthOutput $signalStrengthBars = null)
    {
        $this->SignalStrengthBars = $signalStrengthBars;
        return $this;
    }
    /**
     * Get SignalStrengthInternal value
     * @return \CustomerManagement\StructType\SignalStrengthOutput|null
     */
    public function getSignalStrengthInternal()
    {
        return $this->SignalStrengthInternal;
    }
    /**
     * Set SignalStrengthInternal value
     * @param \CustomerManagement\StructType\SignalStrengthOutput $signalStrengthInternal
     * @return \CustomerManagement\StructType\CellSignalingSummaryOutput
     */
    public function setSignalStrengthInternal(\CustomerManagement\StructType\SignalStrengthOutput $signalStrengthInternal = null)
    {
        $this->SignalStrengthInternal = $signalStrengthInternal;
        return $this;
    }
}
