<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EventHistoryItem StructType
 * @subpackage Structs
 */
class EventHistoryItem extends AbstractStructBase
{
    /**
     * The DeviceId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $DeviceId;
    /**
     * The EventType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $EventType;
    /**
     * The EventDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $EventDate;
    /**
     * Constructor method for EventHistoryItem
     * @uses EventHistoryItem::setDeviceId()
     * @uses EventHistoryItem::setEventType()
     * @uses EventHistoryItem::setEventDate()
     * @param int $deviceId
     * @param string $eventType
     * @param string $eventDate
     */
    public function __construct($deviceId = null, $eventType = null, $eventDate = null)
    {
        $this
            ->setDeviceId($deviceId)
            ->setEventType($eventType)
            ->setEventDate($eventDate);
    }
    /**
     * Get DeviceId value
     * @return int
     */
    public function getDeviceId()
    {
        return $this->DeviceId;
    }
    /**
     * Set DeviceId value
     * @param int $deviceId
     * @return \CustomerManagement\StructType\EventHistoryItem
     */
    public function setDeviceId($deviceId = null)
    {
        // validation for constraint: int
        if (!is_null($deviceId) && !(is_int($deviceId) || ctype_digit($deviceId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($deviceId, true), gettype($deviceId)), __LINE__);
        }
        $this->DeviceId = $deviceId;
        return $this;
    }
    /**
     * Get EventType value
     * @return string
     */
    public function getEventType()
    {
        return $this->EventType;
    }
    /**
     * Set EventType value
     * @uses \CustomerManagement\EnumType\HistoryEventTypeEnum::valueIsValid()
     * @uses \CustomerManagement\EnumType\HistoryEventTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $eventType
     * @return \CustomerManagement\StructType\EventHistoryItem
     */
    public function setEventType($eventType = null)
    {
        // validation for constraint: enumeration
        if (!\CustomerManagement\EnumType\HistoryEventTypeEnum::valueIsValid($eventType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CustomerManagement\EnumType\HistoryEventTypeEnum', is_array($eventType) ? implode(', ', $eventType) : var_export($eventType, true), implode(', ', \CustomerManagement\EnumType\HistoryEventTypeEnum::getValidValues())), __LINE__);
        }
        $this->EventType = $eventType;
        return $this;
    }
    /**
     * Get EventDate value
     * @return string
     */
    public function getEventDate()
    {
        return $this->EventDate;
    }
    /**
     * Set EventDate value
     * @param string $eventDate
     * @return \CustomerManagement\StructType\EventHistoryItem
     */
    public function setEventDate($eventDate = null)
    {
        // validation for constraint: string
        if (!is_null($eventDate) && !is_string($eventDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventDate, true), gettype($eventDate)), __LINE__);
        }
        $this->EventDate = $eventDate;
        return $this;
    }
}
