<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateCustomerBranch StructType
 * @subpackage Structs
 */
class UpdateCustomerBranch extends AbstractStructBase
{
    /**
     * The customerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $customerId;
    /**
     * The destinationBranchId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $destinationBranchId;
    /**
     * Constructor method for UpdateCustomerBranch
     * @uses UpdateCustomerBranch::setCustomerId()
     * @uses UpdateCustomerBranch::setDestinationBranchId()
     * @param int $customerId
     * @param int $destinationBranchId
     */
    public function __construct($customerId = null, $destinationBranchId = null)
    {
        $this
            ->setCustomerId($customerId)
            ->setDestinationBranchId($destinationBranchId);
    }
    /**
     * Get customerId value
     * @return int
     */
    public function getCustomerId()
    {
        return $this->customerId;
    }
    /**
     * Set customerId value
     * @param int $customerId
     * @return \CustomerManagement\StructType\UpdateCustomerBranch
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: int
        if (!is_null($customerId) && !(is_int($customerId) || ctype_digit($customerId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($customerId, true), gettype($customerId)), __LINE__);
        }
        $this->customerId = $customerId;
        return $this;
    }
    /**
     * Get destinationBranchId value
     * @return int
     */
    public function getDestinationBranchId()
    {
        return $this->destinationBranchId;
    }
    /**
     * Set destinationBranchId value
     * @param int $destinationBranchId
     * @return \CustomerManagement\StructType\UpdateCustomerBranch
     */
    public function setDestinationBranchId($destinationBranchId = null)
    {
        // validation for constraint: int
        if (!is_null($destinationBranchId) && !(is_int($destinationBranchId) || ctype_digit($destinationBranchId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($destinationBranchId, true), gettype($destinationBranchId)), __LINE__);
        }
        $this->destinationBranchId = $destinationBranchId;
        return $this;
    }
}
