<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DeviceBatteryInfo StructType
 * @subpackage Structs
 */
class DeviceBatteryInfo extends AbstractStructBase
{
    /**
     * The DeviceId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $DeviceId;
    /**
     * The PowerSourceTypeEnum
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $PowerSourceTypeEnum;
    /**
     * The BatteryPercentage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $BatteryPercentage;
    /**
     * Constructor method for DeviceBatteryInfo
     * @uses DeviceBatteryInfo::setDeviceId()
     * @uses DeviceBatteryInfo::setPowerSourceTypeEnum()
     * @uses DeviceBatteryInfo::setBatteryPercentage()
     * @param int $deviceId
     * @param string $powerSourceTypeEnum
     * @param int $batteryPercentage
     */
    public function __construct($deviceId = null, $powerSourceTypeEnum = null, $batteryPercentage = null)
    {
        $this
            ->setDeviceId($deviceId)
            ->setPowerSourceTypeEnum($powerSourceTypeEnum)
            ->setBatteryPercentage($batteryPercentage);
    }
    /**
     * Get DeviceId value
     * @return int
     */
    public function getDeviceId()
    {
        return $this->DeviceId;
    }
    /**
     * Set DeviceId value
     * @param int $deviceId
     * @return \CustomerManagement\StructType\DeviceBatteryInfo
     */
    public function setDeviceId($deviceId = null)
    {
        // validation for constraint: int
        if (!is_null($deviceId) && !(is_int($deviceId) || ctype_digit($deviceId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($deviceId, true), gettype($deviceId)), __LINE__);
        }
        $this->DeviceId = $deviceId;
        return $this;
    }
    /**
     * Get PowerSourceTypeEnum value
     * @return string
     */
    public function getPowerSourceTypeEnum()
    {
        return $this->PowerSourceTypeEnum;
    }
    /**
     * Set PowerSourceTypeEnum value
     * @uses \CustomerManagement\EnumType\PowerSourceTypeEnum::valueIsValid()
     * @uses \CustomerManagement\EnumType\PowerSourceTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $powerSourceTypeEnum
     * @return \CustomerManagement\StructType\DeviceBatteryInfo
     */
    public function setPowerSourceTypeEnum($powerSourceTypeEnum = null)
    {
        // validation for constraint: enumeration
        if (!\CustomerManagement\EnumType\PowerSourceTypeEnum::valueIsValid($powerSourceTypeEnum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CustomerManagement\EnumType\PowerSourceTypeEnum', is_array($powerSourceTypeEnum) ? implode(', ', $powerSourceTypeEnum) : var_export($powerSourceTypeEnum, true), implode(', ', \CustomerManagement\EnumType\PowerSourceTypeEnum::getValidValues())), __LINE__);
        }
        $this->PowerSourceTypeEnum = $powerSourceTypeEnum;
        return $this;
    }
    /**
     * Get BatteryPercentage value
     * @return int
     */
    public function getBatteryPercentage()
    {
        return $this->BatteryPercentage;
    }
    /**
     * Set BatteryPercentage value
     * @param int $batteryPercentage
     * @return \CustomerManagement\StructType\DeviceBatteryInfo
     */
    public function setBatteryPercentage($batteryPercentage = null)
    {
        // validation for constraint: int
        if (!is_null($batteryPercentage) && !(is_int($batteryPercentage) || ctype_digit($batteryPercentage))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($batteryPercentage, true), gettype($batteryPercentage)), __LINE__);
        }
        $this->BatteryPercentage = $batteryPercentage;
        return $this;
    }
}
