<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomerTroubleCondition StructType
 * @subpackage Structs
 */
class CustomerTroubleCondition extends AbstractStructBase
{
    /**
     * The DeviceId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $DeviceId;
    /**
     * The DeviceIdInPanel
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $DeviceIdInPanel;
    /**
     * The DeviceType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $DeviceType;
    /**
     * The DeviceDesc
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DeviceDesc;
    /**
     * The DeviceDetail
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CustomerManagement\StructType\DeviceDetailInfo
     */
    public $DeviceDetail;
    /**
     * The TroubleConditions
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CustomerManagement\ArrayType\ArrayOfTroubleConditionWithDates
     */
    public $TroubleConditions;
    /**
     * Constructor method for CustomerTroubleCondition
     * @uses CustomerTroubleCondition::setDeviceId()
     * @uses CustomerTroubleCondition::setDeviceIdInPanel()
     * @uses CustomerTroubleCondition::setDeviceType()
     * @uses CustomerTroubleCondition::setDeviceDesc()
     * @uses CustomerTroubleCondition::setDeviceDetail()
     * @uses CustomerTroubleCondition::setTroubleConditions()
     * @param int $deviceId
     * @param int $deviceIdInPanel
     * @param string $deviceType
     * @param string $deviceDesc
     * @param \CustomerManagement\StructType\DeviceDetailInfo $deviceDetail
     * @param \CustomerManagement\ArrayType\ArrayOfTroubleConditionWithDates $troubleConditions
     */
    public function __construct($deviceId = null, $deviceIdInPanel = null, $deviceType = null, $deviceDesc = null, \CustomerManagement\StructType\DeviceDetailInfo $deviceDetail = null, \CustomerManagement\ArrayType\ArrayOfTroubleConditionWithDates $troubleConditions = null)
    {
        $this
            ->setDeviceId($deviceId)
            ->setDeviceIdInPanel($deviceIdInPanel)
            ->setDeviceType($deviceType)
            ->setDeviceDesc($deviceDesc)
            ->setDeviceDetail($deviceDetail)
            ->setTroubleConditions($troubleConditions);
    }
    /**
     * Get DeviceId value
     * @return int
     */
    public function getDeviceId()
    {
        return $this->DeviceId;
    }
    /**
     * Set DeviceId value
     * @param int $deviceId
     * @return \CustomerManagement\StructType\CustomerTroubleCondition
     */
    public function setDeviceId($deviceId = null)
    {
        // validation for constraint: int
        if (!is_null($deviceId) && !(is_int($deviceId) || ctype_digit($deviceId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($deviceId, true), gettype($deviceId)), __LINE__);
        }
        $this->DeviceId = $deviceId;
        return $this;
    }
    /**
     * Get DeviceIdInPanel value
     * @return int
     */
    public function getDeviceIdInPanel()
    {
        return $this->DeviceIdInPanel;
    }
    /**
     * Set DeviceIdInPanel value
     * @param int $deviceIdInPanel
     * @return \CustomerManagement\StructType\CustomerTroubleCondition
     */
    public function setDeviceIdInPanel($deviceIdInPanel = null)
    {
        // validation for constraint: int
        if (!is_null($deviceIdInPanel) && !(is_int($deviceIdInPanel) || ctype_digit($deviceIdInPanel))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($deviceIdInPanel, true), gettype($deviceIdInPanel)), __LINE__);
        }
        $this->DeviceIdInPanel = $deviceIdInPanel;
        return $this;
    }
    /**
     * Get DeviceType value
     * @return string
     */
    public function getDeviceType()
    {
        return $this->DeviceType;
    }
    /**
     * Set DeviceType value
     * @uses \CustomerManagement\EnumType\DeviceTypeEnum::valueIsValid()
     * @uses \CustomerManagement\EnumType\DeviceTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $deviceType
     * @return \CustomerManagement\StructType\CustomerTroubleCondition
     */
    public function setDeviceType($deviceType = null)
    {
        // validation for constraint: enumeration
        if (!\CustomerManagement\EnumType\DeviceTypeEnum::valueIsValid($deviceType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CustomerManagement\EnumType\DeviceTypeEnum', is_array($deviceType) ? implode(', ', $deviceType) : var_export($deviceType, true), implode(', ', \CustomerManagement\EnumType\DeviceTypeEnum::getValidValues())), __LINE__);
        }
        $this->DeviceType = $deviceType;
        return $this;
    }
    /**
     * Get DeviceDesc value
     * @return string|null
     */
    public function getDeviceDesc()
    {
        return $this->DeviceDesc;
    }
    /**
     * Set DeviceDesc value
     * @param string $deviceDesc
     * @return \CustomerManagement\StructType\CustomerTroubleCondition
     */
    public function setDeviceDesc($deviceDesc = null)
    {
        // validation for constraint: string
        if (!is_null($deviceDesc) && !is_string($deviceDesc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deviceDesc, true), gettype($deviceDesc)), __LINE__);
        }
        $this->DeviceDesc = $deviceDesc;
        return $this;
    }
    /**
     * Get DeviceDetail value
     * @return \CustomerManagement\StructType\DeviceDetailInfo|null
     */
    public function getDeviceDetail()
    {
        return $this->DeviceDetail;
    }
    /**
     * Set DeviceDetail value
     * @param \CustomerManagement\StructType\DeviceDetailInfo $deviceDetail
     * @return \CustomerManagement\StructType\CustomerTroubleCondition
     */
    public function setDeviceDetail(\CustomerManagement\StructType\DeviceDetailInfo $deviceDetail = null)
    {
        $this->DeviceDetail = $deviceDetail;
        return $this;
    }
    /**
     * Get TroubleConditions value
     * @return \CustomerManagement\ArrayType\ArrayOfTroubleConditionWithDates|null
     */
    public function getTroubleConditions()
    {
        return $this->TroubleConditions;
    }
    /**
     * Set TroubleConditions value
     * @param \CustomerManagement\ArrayType\ArrayOfTroubleConditionWithDates $troubleConditions
     * @return \CustomerManagement\StructType\CustomerTroubleCondition
     */
    public function setTroubleConditions(\CustomerManagement\ArrayType\ArrayOfTroubleConditionWithDates $troubleConditions = null)
    {
        $this->TroubleConditions = $troubleConditions;
        return $this;
    }
}
