<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RequestFirmwareUpgradeQolsys StructType
 * @subpackage Structs
 */
class RequestFirmwareUpgradeQolsys extends AbstractStructBase
{
    /**
     * The customerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $customerId;
    /**
     * The newVersion
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $newVersion;
    /**
     * The timeToUpdate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $timeToUpdate;
    /**
     * Constructor method for RequestFirmwareUpgradeQolsys
     * @uses RequestFirmwareUpgradeQolsys::setCustomerId()
     * @uses RequestFirmwareUpgradeQolsys::setNewVersion()
     * @uses RequestFirmwareUpgradeQolsys::setTimeToUpdate()
     * @param int $customerId
     * @param string $newVersion
     * @param string $timeToUpdate
     */
    public function __construct($customerId = null, $newVersion = null, $timeToUpdate = null)
    {
        $this
            ->setCustomerId($customerId)
            ->setNewVersion($newVersion)
            ->setTimeToUpdate($timeToUpdate);
    }
    /**
     * Get customerId value
     * @return int
     */
    public function getCustomerId()
    {
        return $this->customerId;
    }
    /**
     * Set customerId value
     * @param int $customerId
     * @return \CustomerManagement\StructType\RequestFirmwareUpgradeQolsys
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: int
        if (!is_null($customerId) && !(is_int($customerId) || ctype_digit($customerId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($customerId, true), gettype($customerId)), __LINE__);
        }
        $this->customerId = $customerId;
        return $this;
    }
    /**
     * Get newVersion value
     * @return string
     */
    public function getNewVersion()
    {
        return $this->newVersion;
    }
    /**
     * Set newVersion value
     * @uses \CustomerManagement\EnumType\FirmwareUpgradeEnumQolsys::valueIsValid()
     * @uses \CustomerManagement\EnumType\FirmwareUpgradeEnumQolsys::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $newVersion
     * @return \CustomerManagement\StructType\RequestFirmwareUpgradeQolsys
     */
    public function setNewVersion($newVersion = null)
    {
        // validation for constraint: enumeration
        if (!\CustomerManagement\EnumType\FirmwareUpgradeEnumQolsys::valueIsValid($newVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CustomerManagement\EnumType\FirmwareUpgradeEnumQolsys', is_array($newVersion) ? implode(', ', $newVersion) : var_export($newVersion, true), implode(', ', \CustomerManagement\EnumType\FirmwareUpgradeEnumQolsys::getValidValues())), __LINE__);
        }
        $this->newVersion = $newVersion;
        return $this;
    }
    /**
     * Get timeToUpdate value
     * @return string
     */
    public function getTimeToUpdate()
    {
        return $this->timeToUpdate;
    }
    /**
     * Set timeToUpdate value
     * @param string $timeToUpdate
     * @return \CustomerManagement\StructType\RequestFirmwareUpgradeQolsys
     */
    public function setTimeToUpdate($timeToUpdate = null)
    {
        // validation for constraint: string
        if (!is_null($timeToUpdate) && !is_string($timeToUpdate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($timeToUpdate, true), gettype($timeToUpdate)), __LINE__);
        }
        $this->timeToUpdate = $timeToUpdate;
        return $this;
    }
}
