<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdatePrimaryEmail StructType
 * @subpackage Structs
 */
class UpdatePrimaryEmail extends AbstractStructBase
{
    /**
     * The customerId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $customerId;
    /**
     * The newEmailAddress
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $newEmailAddress;
    /**
     * Constructor method for UpdatePrimaryEmail
     * @uses UpdatePrimaryEmail::setCustomerId()
     * @uses UpdatePrimaryEmail::setNewEmailAddress()
     * @param int $customerId
     * @param string $newEmailAddress
     */
    public function __construct($customerId = null, $newEmailAddress = null)
    {
        $this
            ->setCustomerId($customerId)
            ->setNewEmailAddress($newEmailAddress);
    }
    /**
     * Get customerId value
     * @return int
     */
    public function getCustomerId()
    {
        return $this->customerId;
    }
    /**
     * Set customerId value
     * @param int $customerId
     * @return \CustomerManagement\StructType\UpdatePrimaryEmail
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: int
        if (!is_null($customerId) && !is_numeric($customerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($customerId)), __LINE__);
        }
        $this->customerId = $customerId;
        return $this;
    }
    /**
     * Get newEmailAddress value
     * @return string|null
     */
    public function getNewEmailAddress()
    {
        return $this->newEmailAddress;
    }
    /**
     * Set newEmailAddress value
     * @param string $newEmailAddress
     * @return \CustomerManagement\StructType\UpdatePrimaryEmail
     */
    public function setNewEmailAddress($newEmailAddress = null)
    {
        // validation for constraint: string
        if (!is_null($newEmailAddress) && !is_string($newEmailAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($newEmailAddress)), __LINE__);
        }
        $this->newEmailAddress = $newEmailAddress;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CustomerManagement\StructType\UpdatePrimaryEmail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
