<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RemoteRoutineInspectionReport StructType
 * @subpackage Structs
 */
class RemoteRoutineInspectionReport extends AbstractStructBase
{
    /**
     * The RRIInstanceCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $RRIInstanceCode;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Status;
    /**
     * The SoakTestReport
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CustomerManagement\StructType\ActiveSoakTests
     */
    public $SoakTestReport;
    /**
     * The PPSReport
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CustomerManagement\StructType\PPSFailure
     */
    public $PPSReport;
    /**
     * The APSReport
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CustomerManagement\StructType\APSFailure
     */
    public $APSReport;
    /**
     * The ATSReport
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CustomerManagement\StructType\ATSFailure
     */
    public $ATSReport;
    /**
     * The ClockFailureReport
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CustomerManagement\StructType\ClockFailure
     */
    public $ClockFailureReport;
    /**
     * The FrequentlyUsedDetectorsReport
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CustomerManagement\StructType\FrequentlyUsedDetectors
     */
    public $FrequentlyUsedDetectorsReport;
    /**
     * The SetUnsetEventsReport
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CustomerManagement\StructType\SetUnsetEvents
     */
    public $SetUnsetEventsReport;
    /**
     * The EventsReport
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CustomerManagement\StructType\EventRecord
     */
    public $EventsReport;
    /**
     * The InhibitedIsolatedZonesReport
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CustomerManagement\StructType\InhibitedIsolatedZones
     */
    public $InhibitedIsolatedZonesReport;
    /**
     * The TroubleConditionsRestoresReport
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CustomerManagement\ArrayType\ArrayOfTroubleConditionsRestoresItem
     */
    public $TroubleConditionsRestoresReport;
    /**
     * The ReportParams
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CustomerManagement\StructType\RequestRemoteRoutineInspectionInput
     */
    public $ReportParams;
    /**
     * Constructor method for RemoteRoutineInspectionReport
     * @uses RemoteRoutineInspectionReport::setRRIInstanceCode()
     * @uses RemoteRoutineInspectionReport::setStatus()
     * @uses RemoteRoutineInspectionReport::setSoakTestReport()
     * @uses RemoteRoutineInspectionReport::setPPSReport()
     * @uses RemoteRoutineInspectionReport::setAPSReport()
     * @uses RemoteRoutineInspectionReport::setATSReport()
     * @uses RemoteRoutineInspectionReport::setClockFailureReport()
     * @uses RemoteRoutineInspectionReport::setFrequentlyUsedDetectorsReport()
     * @uses RemoteRoutineInspectionReport::setSetUnsetEventsReport()
     * @uses RemoteRoutineInspectionReport::setEventsReport()
     * @uses RemoteRoutineInspectionReport::setInhibitedIsolatedZonesReport()
     * @uses RemoteRoutineInspectionReport::setTroubleConditionsRestoresReport()
     * @uses RemoteRoutineInspectionReport::setReportParams()
     * @param int $rRIInstanceCode
     * @param string $status
     * @param \CustomerManagement\StructType\ActiveSoakTests $soakTestReport
     * @param \CustomerManagement\StructType\PPSFailure $pPSReport
     * @param \CustomerManagement\StructType\APSFailure $aPSReport
     * @param \CustomerManagement\StructType\ATSFailure $aTSReport
     * @param \CustomerManagement\StructType\ClockFailure $clockFailureReport
     * @param \CustomerManagement\StructType\FrequentlyUsedDetectors $frequentlyUsedDetectorsReport
     * @param \CustomerManagement\StructType\SetUnsetEvents $setUnsetEventsReport
     * @param \CustomerManagement\StructType\EventRecord $eventsReport
     * @param \CustomerManagement\StructType\InhibitedIsolatedZones $inhibitedIsolatedZonesReport
     * @param \CustomerManagement\ArrayType\ArrayOfTroubleConditionsRestoresItem $troubleConditionsRestoresReport
     * @param \CustomerManagement\StructType\RequestRemoteRoutineInspectionInput $reportParams
     */
    public function __construct($rRIInstanceCode = null, $status = null, \CustomerManagement\StructType\ActiveSoakTests $soakTestReport = null, \CustomerManagement\StructType\PPSFailure $pPSReport = null, \CustomerManagement\StructType\APSFailure $aPSReport = null, \CustomerManagement\StructType\ATSFailure $aTSReport = null, \CustomerManagement\StructType\ClockFailure $clockFailureReport = null, \CustomerManagement\StructType\FrequentlyUsedDetectors $frequentlyUsedDetectorsReport = null, \CustomerManagement\StructType\SetUnsetEvents $setUnsetEventsReport = null, \CustomerManagement\StructType\EventRecord $eventsReport = null, \CustomerManagement\StructType\InhibitedIsolatedZones $inhibitedIsolatedZonesReport = null, \CustomerManagement\ArrayType\ArrayOfTroubleConditionsRestoresItem $troubleConditionsRestoresReport = null, \CustomerManagement\StructType\RequestRemoteRoutineInspectionInput $reportParams = null)
    {
        $this
            ->setRRIInstanceCode($rRIInstanceCode)
            ->setStatus($status)
            ->setSoakTestReport($soakTestReport)
            ->setPPSReport($pPSReport)
            ->setAPSReport($aPSReport)
            ->setATSReport($aTSReport)
            ->setClockFailureReport($clockFailureReport)
            ->setFrequentlyUsedDetectorsReport($frequentlyUsedDetectorsReport)
            ->setSetUnsetEventsReport($setUnsetEventsReport)
            ->setEventsReport($eventsReport)
            ->setInhibitedIsolatedZonesReport($inhibitedIsolatedZonesReport)
            ->setTroubleConditionsRestoresReport($troubleConditionsRestoresReport)
            ->setReportParams($reportParams);
    }
    /**
     * Get RRIInstanceCode value
     * @return int
     */
    public function getRRIInstanceCode()
    {
        return $this->RRIInstanceCode;
    }
    /**
     * Set RRIInstanceCode value
     * @param int $rRIInstanceCode
     * @return \CustomerManagement\StructType\RemoteRoutineInspectionReport
     */
    public function setRRIInstanceCode($rRIInstanceCode = null)
    {
        // validation for constraint: int
        if (!is_null($rRIInstanceCode) && !(is_int($rRIInstanceCode) || ctype_digit($rRIInstanceCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($rRIInstanceCode, true), gettype($rRIInstanceCode)), __LINE__);
        }
        $this->RRIInstanceCode = $rRIInstanceCode;
        return $this;
    }
    /**
     * Get Status value
     * @return string
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @uses \CustomerManagement\EnumType\RRIReportStatusEnum::valueIsValid()
     * @uses \CustomerManagement\EnumType\RRIReportStatusEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \CustomerManagement\StructType\RemoteRoutineInspectionReport
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\CustomerManagement\EnumType\RRIReportStatusEnum::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CustomerManagement\EnumType\RRIReportStatusEnum', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \CustomerManagement\EnumType\RRIReportStatusEnum::getValidValues())), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get SoakTestReport value
     * @return \CustomerManagement\StructType\ActiveSoakTests|null
     */
    public function getSoakTestReport()
    {
        return $this->SoakTestReport;
    }
    /**
     * Set SoakTestReport value
     * @param \CustomerManagement\StructType\ActiveSoakTests $soakTestReport
     * @return \CustomerManagement\StructType\RemoteRoutineInspectionReport
     */
    public function setSoakTestReport(\CustomerManagement\StructType\ActiveSoakTests $soakTestReport = null)
    {
        $this->SoakTestReport = $soakTestReport;
        return $this;
    }
    /**
     * Get PPSReport value
     * @return \CustomerManagement\StructType\PPSFailure|null
     */
    public function getPPSReport()
    {
        return $this->PPSReport;
    }
    /**
     * Set PPSReport value
     * @param \CustomerManagement\StructType\PPSFailure $pPSReport
     * @return \CustomerManagement\StructType\RemoteRoutineInspectionReport
     */
    public function setPPSReport(\CustomerManagement\StructType\PPSFailure $pPSReport = null)
    {
        $this->PPSReport = $pPSReport;
        return $this;
    }
    /**
     * Get APSReport value
     * @return \CustomerManagement\StructType\APSFailure|null
     */
    public function getAPSReport()
    {
        return $this->APSReport;
    }
    /**
     * Set APSReport value
     * @param \CustomerManagement\StructType\APSFailure $aPSReport
     * @return \CustomerManagement\StructType\RemoteRoutineInspectionReport
     */
    public function setAPSReport(\CustomerManagement\StructType\APSFailure $aPSReport = null)
    {
        $this->APSReport = $aPSReport;
        return $this;
    }
    /**
     * Get ATSReport value
     * @return \CustomerManagement\StructType\ATSFailure|null
     */
    public function getATSReport()
    {
        return $this->ATSReport;
    }
    /**
     * Set ATSReport value
     * @param \CustomerManagement\StructType\ATSFailure $aTSReport
     * @return \CustomerManagement\StructType\RemoteRoutineInspectionReport
     */
    public function setATSReport(\CustomerManagement\StructType\ATSFailure $aTSReport = null)
    {
        $this->ATSReport = $aTSReport;
        return $this;
    }
    /**
     * Get ClockFailureReport value
     * @return \CustomerManagement\StructType\ClockFailure|null
     */
    public function getClockFailureReport()
    {
        return $this->ClockFailureReport;
    }
    /**
     * Set ClockFailureReport value
     * @param \CustomerManagement\StructType\ClockFailure $clockFailureReport
     * @return \CustomerManagement\StructType\RemoteRoutineInspectionReport
     */
    public function setClockFailureReport(\CustomerManagement\StructType\ClockFailure $clockFailureReport = null)
    {
        $this->ClockFailureReport = $clockFailureReport;
        return $this;
    }
    /**
     * Get FrequentlyUsedDetectorsReport value
     * @return \CustomerManagement\StructType\FrequentlyUsedDetectors|null
     */
    public function getFrequentlyUsedDetectorsReport()
    {
        return $this->FrequentlyUsedDetectorsReport;
    }
    /**
     * Set FrequentlyUsedDetectorsReport value
     * @param \CustomerManagement\StructType\FrequentlyUsedDetectors $frequentlyUsedDetectorsReport
     * @return \CustomerManagement\StructType\RemoteRoutineInspectionReport
     */
    public function setFrequentlyUsedDetectorsReport(\CustomerManagement\StructType\FrequentlyUsedDetectors $frequentlyUsedDetectorsReport = null)
    {
        $this->FrequentlyUsedDetectorsReport = $frequentlyUsedDetectorsReport;
        return $this;
    }
    /**
     * Get SetUnsetEventsReport value
     * @return \CustomerManagement\StructType\SetUnsetEvents|null
     */
    public function getSetUnsetEventsReport()
    {
        return $this->SetUnsetEventsReport;
    }
    /**
     * Set SetUnsetEventsReport value
     * @param \CustomerManagement\StructType\SetUnsetEvents $setUnsetEventsReport
     * @return \CustomerManagement\StructType\RemoteRoutineInspectionReport
     */
    public function setSetUnsetEventsReport(\CustomerManagement\StructType\SetUnsetEvents $setUnsetEventsReport = null)
    {
        $this->SetUnsetEventsReport = $setUnsetEventsReport;
        return $this;
    }
    /**
     * Get EventsReport value
     * @return \CustomerManagement\StructType\EventRecord|null
     */
    public function getEventsReport()
    {
        return $this->EventsReport;
    }
    /**
     * Set EventsReport value
     * @param \CustomerManagement\StructType\EventRecord $eventsReport
     * @return \CustomerManagement\StructType\RemoteRoutineInspectionReport
     */
    public function setEventsReport(\CustomerManagement\StructType\EventRecord $eventsReport = null)
    {
        $this->EventsReport = $eventsReport;
        return $this;
    }
    /**
     * Get InhibitedIsolatedZonesReport value
     * @return \CustomerManagement\StructType\InhibitedIsolatedZones|null
     */
    public function getInhibitedIsolatedZonesReport()
    {
        return $this->InhibitedIsolatedZonesReport;
    }
    /**
     * Set InhibitedIsolatedZonesReport value
     * @param \CustomerManagement\StructType\InhibitedIsolatedZones $inhibitedIsolatedZonesReport
     * @return \CustomerManagement\StructType\RemoteRoutineInspectionReport
     */
    public function setInhibitedIsolatedZonesReport(\CustomerManagement\StructType\InhibitedIsolatedZones $inhibitedIsolatedZonesReport = null)
    {
        $this->InhibitedIsolatedZonesReport = $inhibitedIsolatedZonesReport;
        return $this;
    }
    /**
     * Get TroubleConditionsRestoresReport value
     * @return \CustomerManagement\ArrayType\ArrayOfTroubleConditionsRestoresItem|null
     */
    public function getTroubleConditionsRestoresReport()
    {
        return $this->TroubleConditionsRestoresReport;
    }
    /**
     * Set TroubleConditionsRestoresReport value
     * @param \CustomerManagement\ArrayType\ArrayOfTroubleConditionsRestoresItem $troubleConditionsRestoresReport
     * @return \CustomerManagement\StructType\RemoteRoutineInspectionReport
     */
    public function setTroubleConditionsRestoresReport(\CustomerManagement\ArrayType\ArrayOfTroubleConditionsRestoresItem $troubleConditionsRestoresReport = null)
    {
        $this->TroubleConditionsRestoresReport = $troubleConditionsRestoresReport;
        return $this;
    }
    /**
     * Get ReportParams value
     * @return \CustomerManagement\StructType\RequestRemoteRoutineInspectionInput|null
     */
    public function getReportParams()
    {
        return $this->ReportParams;
    }
    /**
     * Set ReportParams value
     * @param \CustomerManagement\StructType\RequestRemoteRoutineInspectionInput $reportParams
     * @return \CustomerManagement\StructType\RemoteRoutineInspectionReport
     */
    public function setReportParams(\CustomerManagement\StructType\RequestRemoteRoutineInspectionInput $reportParams = null)
    {
        $this->ReportParams = $reportParams;
        return $this;
    }
}
