<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DeleteVideoDeviceInput StructType
 * @subpackage Structs
 */
class DeleteVideoDeviceInput extends AbstractStructBase
{
    /**
     * The CustomerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CustomerId;
    /**
     * The VideoDeviceMacAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $VideoDeviceMacAddress;
    /**
     * Constructor method for DeleteVideoDeviceInput
     * @uses DeleteVideoDeviceInput::setCustomerId()
     * @uses DeleteVideoDeviceInput::setVideoDeviceMacAddress()
     * @param int $customerId
     * @param string $videoDeviceMacAddress
     */
    public function __construct($customerId = null, $videoDeviceMacAddress = null)
    {
        $this
            ->setCustomerId($customerId)
            ->setVideoDeviceMacAddress($videoDeviceMacAddress);
    }
    /**
     * Get CustomerId value
     * @return int
     */
    public function getCustomerId()
    {
        return $this->CustomerId;
    }
    /**
     * Set CustomerId value
     * @param int $customerId
     * @return \CustomerManagement\StructType\DeleteVideoDeviceInput
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: int
        if (!is_null($customerId) && !(is_int($customerId) || ctype_digit($customerId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($customerId, true), gettype($customerId)), __LINE__);
        }
        $this->CustomerId = $customerId;
        return $this;
    }
    /**
     * Get VideoDeviceMacAddress value
     * @return string|null
     */
    public function getVideoDeviceMacAddress()
    {
        return $this->VideoDeviceMacAddress;
    }
    /**
     * Set VideoDeviceMacAddress value
     * @param string $videoDeviceMacAddress
     * @return \CustomerManagement\StructType\DeleteVideoDeviceInput
     */
    public function setVideoDeviceMacAddress($videoDeviceMacAddress = null)
    {
        // validation for constraint: string
        if (!is_null($videoDeviceMacAddress) && !is_string($videoDeviceMacAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($videoDeviceMacAddress, true), gettype($videoDeviceMacAddress)), __LINE__);
        }
        $this->VideoDeviceMacAddress = $videoDeviceMacAddress;
        return $this;
    }
}
