<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RecordAgreementResponseInput StructType
 * @subpackage Structs
 */
class RecordAgreementResponseInput extends AbstractStructBase
{
    /**
     * The AgreementVersion
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AgreementVersion;
    /**
     * The AgreementType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AgreementType;
    /**
     * The LoginName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LoginName;
    /**
     * The AgreementCulture
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AgreementCulture;
    /**
     * Constructor method for RecordAgreementResponseInput
     * @uses RecordAgreementResponseInput::setAgreementVersion()
     * @uses RecordAgreementResponseInput::setAgreementType()
     * @uses RecordAgreementResponseInput::setLoginName()
     * @uses RecordAgreementResponseInput::setAgreementCulture()
     * @param int $agreementVersion
     * @param int $agreementType
     * @param string $loginName
     * @param string $agreementCulture
     */
    public function __construct($agreementVersion = null, $agreementType = null, $loginName = null, $agreementCulture = null)
    {
        $this
            ->setAgreementVersion($agreementVersion)
            ->setAgreementType($agreementType)
            ->setLoginName($loginName)
            ->setAgreementCulture($agreementCulture);
    }
    /**
     * Get AgreementVersion value
     * @return int
     */
    public function getAgreementVersion()
    {
        return $this->AgreementVersion;
    }
    /**
     * Set AgreementVersion value
     * @param int $agreementVersion
     * @return \CustomerManagement\StructType\RecordAgreementResponseInput
     */
    public function setAgreementVersion($agreementVersion = null)
    {
        // validation for constraint: int
        if (!is_null($agreementVersion) && !(is_int($agreementVersion) || ctype_digit($agreementVersion))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($agreementVersion, true), gettype($agreementVersion)), __LINE__);
        }
        $this->AgreementVersion = $agreementVersion;
        return $this;
    }
    /**
     * Get AgreementType value
     * @return int
     */
    public function getAgreementType()
    {
        return $this->AgreementType;
    }
    /**
     * Set AgreementType value
     * @param int $agreementType
     * @return \CustomerManagement\StructType\RecordAgreementResponseInput
     */
    public function setAgreementType($agreementType = null)
    {
        // validation for constraint: int
        if (!is_null($agreementType) && !(is_int($agreementType) || ctype_digit($agreementType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($agreementType, true), gettype($agreementType)), __LINE__);
        }
        $this->AgreementType = $agreementType;
        return $this;
    }
    /**
     * Get LoginName value
     * @return string|null
     */
    public function getLoginName()
    {
        return $this->LoginName;
    }
    /**
     * Set LoginName value
     * @param string $loginName
     * @return \CustomerManagement\StructType\RecordAgreementResponseInput
     */
    public function setLoginName($loginName = null)
    {
        // validation for constraint: string
        if (!is_null($loginName) && !is_string($loginName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($loginName, true), gettype($loginName)), __LINE__);
        }
        $this->LoginName = $loginName;
        return $this;
    }
    /**
     * Get AgreementCulture value
     * @return string|null
     */
    public function getAgreementCulture()
    {
        return $this->AgreementCulture;
    }
    /**
     * Set AgreementCulture value
     * @param string $agreementCulture
     * @return \CustomerManagement\StructType\RecordAgreementResponseInput
     */
    public function setAgreementCulture($agreementCulture = null)
    {
        // validation for constraint: string
        if (!is_null($agreementCulture) && !is_string($agreementCulture)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($agreementCulture, true), gettype($agreementCulture)), __LINE__);
        }
        $this->AgreementCulture = $agreementCulture;
        return $this;
    }
}
