<?php

namespace CustomerManagement\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfAppointmentTypeEnum ArrayType
 * @subpackage Arrays
 */
class ArrayOfAppointmentTypeEnum extends AbstractStructArrayBase
{
    /**
     * The AppointmentTypeEnum
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $AppointmentTypeEnum;
    /**
     * Constructor method for ArrayOfAppointmentTypeEnum
     * @uses ArrayOfAppointmentTypeEnum::setAppointmentTypeEnum()
     * @param string[] $appointmentTypeEnum
     */
    public function __construct(array $appointmentTypeEnum = array())
    {
        $this
            ->setAppointmentTypeEnum($appointmentTypeEnum);
    }
    /**
     * Get AppointmentTypeEnum value
     * @return string[]|null
     */
    public function getAppointmentTypeEnum()
    {
        return $this->AppointmentTypeEnum;
    }
    /**
     * This method is responsible for validating the values passed to the setAppointmentTypeEnum method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAppointmentTypeEnum method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAppointmentTypeEnumForArrayConstraintsFromSetAppointmentTypeEnum(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfAppointmentTypeEnumAppointmentTypeEnumItem) {
            // validation for constraint: enumeration
            if (!\CustomerManagement\EnumType\AppointmentTypeEnum::valueIsValid($arrayOfAppointmentTypeEnumAppointmentTypeEnumItem)) {
                $invalidValues[] = is_object($arrayOfAppointmentTypeEnumAppointmentTypeEnumItem) ? get_class($arrayOfAppointmentTypeEnumAppointmentTypeEnumItem) : sprintf('%s(%s)', gettype($arrayOfAppointmentTypeEnumAppointmentTypeEnumItem), var_export($arrayOfAppointmentTypeEnumAppointmentTypeEnumItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CustomerManagement\EnumType\AppointmentTypeEnum', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \CustomerManagement\EnumType\AppointmentTypeEnum::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AppointmentTypeEnum value
     * @uses \CustomerManagement\EnumType\AppointmentTypeEnum::valueIsValid()
     * @uses \CustomerManagement\EnumType\AppointmentTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $appointmentTypeEnum
     * @return \CustomerManagement\ArrayType\ArrayOfAppointmentTypeEnum
     */
    public function setAppointmentTypeEnum(array $appointmentTypeEnum = array())
    {
        // validation for constraint: array
        if ('' !== ($appointmentTypeEnumArrayErrorMessage = self::validateAppointmentTypeEnumForArrayConstraintsFromSetAppointmentTypeEnum($appointmentTypeEnum))) {
            throw new \InvalidArgumentException($appointmentTypeEnumArrayErrorMessage, __LINE__);
        }
        $this->AppointmentTypeEnum = is_array($appointmentTypeEnum) ? implode(' ', $appointmentTypeEnum) : null;
        return $this;
    }
    /**
     * Add item to AppointmentTypeEnum value
     * @uses \CustomerManagement\EnumType\AppointmentTypeEnum::valueIsValid()
     * @uses \CustomerManagement\EnumType\AppointmentTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \CustomerManagement\ArrayType\ArrayOfAppointmentTypeEnum
     */
    public function addToAppointmentTypeEnum($item)
    {
        // validation for constraint: enumeration
        if (!\CustomerManagement\EnumType\AppointmentTypeEnum::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CustomerManagement\EnumType\AppointmentTypeEnum', is_array($item) ? implode(', ', $item) : var_export($item, true), implode(', ', \CustomerManagement\EnumType\AppointmentTypeEnum::getValidValues())), __LINE__);
        }
        $this->AppointmentTypeEnum[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return string|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return string|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return string|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return string|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return string|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Add element to array
     * @see AbstractStructArrayBase::add()
     * @throws \InvalidArgumentException
     * @uses \CustomerManagement\EnumType\AppointmentTypeEnum::valueIsValid()
     * @param string $item
     * @return \CustomerManagement\ArrayType\ArrayOfAppointmentTypeEnum
     */
    public function add($item)
    {
        // validation for constraint: enumeration
        if (!\CustomerManagement\EnumType\AppointmentTypeEnum::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CustomerManagement\EnumType\AppointmentTypeEnum', is_array($item) ? implode(', ', $item) : var_export($item, true), implode(', ', \CustomerManagement\EnumType\AppointmentTypeEnum::getValidValues())), __LINE__);
        }
        return parent::add($item);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string AppointmentTypeEnum
     */
    public function getAttributeName()
    {
        return 'AppointmentTypeEnum';
    }
}
