<?php

namespace CustomerManagement\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfEventRecordItem ArrayType
 * @subpackage Arrays
 */
class ArrayOfEventRecordItem extends AbstractStructArrayBase
{
    /**
     * The HistoryItem
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \CustomerManagement\StructType\EventRecordItem[]
     */
    public $HistoryItem;
    /**
     * Constructor method for ArrayOfEventRecordItem
     * @uses ArrayOfEventRecordItem::setHistoryItem()
     * @param \CustomerManagement\StructType\EventRecordItem[] $historyItem
     */
    public function __construct(array $historyItem = array())
    {
        $this
            ->setHistoryItem($historyItem);
    }
    /**
     * Get HistoryItem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \CustomerManagement\StructType\EventRecordItem[]|null
     */
    public function getHistoryItem()
    {
        return isset($this->HistoryItem) ? $this->HistoryItem : null;
    }
    /**
     * This method is responsible for validating the values passed to the setHistoryItem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setHistoryItem method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateHistoryItemForArrayConstraintsFromSetHistoryItem(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfEventRecordItemHistoryItemItem) {
            // validation for constraint: itemType
            if (!$arrayOfEventRecordItemHistoryItemItem instanceof \CustomerManagement\StructType\EventRecordItem) {
                $invalidValues[] = is_object($arrayOfEventRecordItemHistoryItemItem) ? get_class($arrayOfEventRecordItemHistoryItemItem) : sprintf('%s(%s)', gettype($arrayOfEventRecordItemHistoryItemItem), var_export($arrayOfEventRecordItemHistoryItemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The HistoryItem property can only contain items of type \CustomerManagement\StructType\EventRecordItem, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set HistoryItem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \CustomerManagement\StructType\EventRecordItem[] $historyItem
     * @return \CustomerManagement\ArrayType\ArrayOfEventRecordItem
     */
    public function setHistoryItem(array $historyItem = array())
    {
        // validation for constraint: array
        if ('' !== ($historyItemArrayErrorMessage = self::validateHistoryItemForArrayConstraintsFromSetHistoryItem($historyItem))) {
            throw new \InvalidArgumentException($historyItemArrayErrorMessage, __LINE__);
        }
        if (is_null($historyItem) || (is_array($historyItem) && empty($historyItem))) {
            unset($this->HistoryItem);
        } else {
            $this->HistoryItem = $historyItem;
        }
        return $this;
    }
    /**
     * Add item to HistoryItem value
     * @throws \InvalidArgumentException
     * @param \CustomerManagement\StructType\EventRecordItem $item
     * @return \CustomerManagement\ArrayType\ArrayOfEventRecordItem
     */
    public function addToHistoryItem(\CustomerManagement\StructType\EventRecordItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \CustomerManagement\StructType\EventRecordItem) {
            throw new \InvalidArgumentException(sprintf('The HistoryItem property can only contain items of type \CustomerManagement\StructType\EventRecordItem, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->HistoryItem[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \CustomerManagement\StructType\EventRecordItem|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \CustomerManagement\StructType\EventRecordItem|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \CustomerManagement\StructType\EventRecordItem|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \CustomerManagement\StructType\EventRecordItem|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \CustomerManagement\StructType\EventRecordItem|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string HistoryItem
     */
    public function getAttributeName()
    {
        return 'HistoryItem';
    }
}
