<?php

namespace CustomerManagement\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Add ServiceType
 * @subpackage Services
 */
class Add extends AbstractSoapClientBase
{
    /**
     * Sets the Authentication SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \CustomerManagement\StructType\Authentication $authentication
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderAuthentication(\CustomerManagement\StructType\Authentication $authentication, $nameSpace = 'http://www.alarm.com/WebServices', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'Authentication', $authentication, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named AddDefaultNotifications
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Add default notifications to a customer.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\AddDefaultNotifications $parameters
     * @return \CustomerManagement\StructType\AddDefaultNotificationsResponse|bool
     */
    public function AddDefaultNotifications(\CustomerManagement\StructType\AddDefaultNotifications $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->AddDefaultNotifications($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddSensorDevice
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: AddSensorDevice. The SensorTypeId field is only needed for Qolsys panels. When naming sensors use SensorNamePrefix for the NX panel; SensorName for Qolsys; and Base, Suffix, Token3, and Token4 for XT/XTi. Please call
     * GetEligibleSensorNames to get the valid descriptors for XT/XTi.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\AddSensorDevice $parameters
     * @return \CustomerManagement\StructType\AddSensorDeviceResponse|bool
     */
    public function AddSensorDevice(\CustomerManagement\StructType\AddSensorDevice $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->AddSensorDevice($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddSensorDeviceFor2Gig
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Add 2Gig Sensor.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\AddSensorDeviceFor2Gig $parameters
     * @return \CustomerManagement\StructType\AddSensorDeviceFor2GigResponse|bool
     */
    public function AddSensorDeviceFor2Gig(\CustomerManagement\StructType\AddSensorDeviceFor2Gig $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->AddSensorDeviceFor2Gig($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddFobFor2Gig
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Add 2Gig Fob.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\AddFobFor2Gig $parameters
     * @return \CustomerManagement\StructType\AddFobFor2GigResponse|bool
     */
    public function AddFobFor2Gig(\CustomerManagement\StructType\AddFobFor2Gig $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->AddFobFor2Gig($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddSensorGetKeyfobProperties
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Returns lists of 2gig sensor key fob properties - Voice Descriptors, Equipment Age and Key 4 Output.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\AddSensorGetKeyfobProperties $parameters
     * @return \CustomerManagement\StructType\AddSensorGetKeyfobPropertiesResponse|bool
     */
    public function AddSensorGetKeyfobProperties(\CustomerManagement\StructType\AddSensorGetKeyfobProperties $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->AddSensorGetKeyfobProperties($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddVideoDevice
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Add Video Device.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\AddVideoDevice $parameters
     * @return \CustomerManagement\StructType\AddVideoDeviceResponse|bool
     */
    public function AddVideoDevice(\CustomerManagement\StructType\AddVideoDevice $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->AddVideoDevice($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddImageSensor
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Add Image Sensor.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\AddImageSensor $parameters
     * @return \CustomerManagement\StructType\AddImageSensorResponse|bool
     */
    public function AddImageSensor(\CustomerManagement\StructType\AddImageSensor $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->AddImageSensor($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddSensorGetSensorVoiceDescriptors
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Returns a list of 2gig sensor voice descriptors.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\AddSensorGetSensorVoiceDescriptors $parameters
     * @return \CustomerManagement\StructType\AddSensorGetSensorVoiceDescriptorsResponse|bool
     */
    public function AddSensorGetSensorVoiceDescriptors(\CustomerManagement\StructType\AddSensorGetSensorVoiceDescriptors $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->AddSensorGetSensorVoiceDescriptors($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddSensorGetSensorTypes
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Returns a list of 2gig sensor types.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\AddSensorGetSensorTypes $parameters
     * @return \CustomerManagement\StructType\AddSensorGetSensorTypesResponse|bool
     */
    public function AddSensorGetSensorTypes(\CustomerManagement\StructType\AddSensorGetSensorTypes $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->AddSensorGetSensorTypes($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddUserCode
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Add a new user code. Calling this method will send a notification to the customer that their user codes have changed.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\AddUserCode $parameters
     * @return \CustomerManagement\StructType\AddUserCodeResponse|bool
     */
    public function AddUserCode(\CustomerManagement\StructType\AddUserCode $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->AddUserCode($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddCustomerToGroup
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\AddCustomerToGroup $parameters
     * @return \CustomerManagement\StructType\AddCustomerToGroupResponse|bool
     */
    public function AddCustomerToGroup(\CustomerManagement\StructType\AddCustomerToGroup $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->AddCustomerToGroup($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddCustomerLogin
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Add a new login to a customer account.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\AddCustomerLogin $parameters
     * @return \CustomerManagement\StructType\AddCustomerLoginResponse|bool
     */
    public function AddCustomerLogin(\CustomerManagement\StructType\AddCustomerLogin $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->AddCustomerLogin($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddExistingLogins
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Add an existing login to a new customer to provide that login access to a new account.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\AddExistingLogins $parameters
     * @return \CustomerManagement\StructType\AddExistingLoginsResponse|bool
     */
    public function AddExistingLogins(\CustomerManagement\StructType\AddExistingLogins $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->AddExistingLogins($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \CustomerManagement\StructType\AddCustomerLoginResponse|\CustomerManagement\StructType\AddCustomerToGroupResponse|\CustomerManagement\StructType\AddDefaultNotificationsResponse|\CustomerManagement\StructType\AddExistingLoginsResponse|\CustomerManagement\StructType\AddFobFor2GigResponse|\CustomerManagement\StructType\AddImageSensorResponse|\CustomerManagement\StructType\AddSensorDeviceFor2GigResponse|\CustomerManagement\StructType\AddSensorDeviceResponse|\CustomerManagement\StructType\AddSensorGetKeyfobPropertiesResponse|\CustomerManagement\StructType\AddSensorGetSensorTypesResponse|\CustomerManagement\StructType\AddSensorGetSensorVoiceDescriptorsResponse|\CustomerManagement\StructType\AddUserCodeResponse|\CustomerManagement\StructType\AddVideoDeviceResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
