<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TroubleConditionsRestoresItem StructType
 * @subpackage Structs
 */
class TroubleConditionsRestoresItem extends AbstractStructBase
{
    /**
     * The Zone
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Zone;
    /**
     * The Partition
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Partition;
    /**
     * The IsRestored
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsRestored;
    /**
     * The TroubleConditionStartUtc
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $TroubleConditionStartUtc;
    /**
     * The TroubleConditionEndUtc
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $TroubleConditionEndUtc;
    /**
     * The Trouble
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Trouble;
    /**
     * Constructor method for TroubleConditionsRestoresItem
     * @uses TroubleConditionsRestoresItem::setZone()
     * @uses TroubleConditionsRestoresItem::setPartition()
     * @uses TroubleConditionsRestoresItem::setIsRestored()
     * @uses TroubleConditionsRestoresItem::setTroubleConditionStartUtc()
     * @uses TroubleConditionsRestoresItem::setTroubleConditionEndUtc()
     * @uses TroubleConditionsRestoresItem::setTrouble()
     * @param int $zone
     * @param int $partition
     * @param bool $isRestored
     * @param string $troubleConditionStartUtc
     * @param string $troubleConditionEndUtc
     * @param string $trouble
     */
    public function __construct($zone = null, $partition = null, $isRestored = null, $troubleConditionStartUtc = null, $troubleConditionEndUtc = null, $trouble = null)
    {
        $this
            ->setZone($zone)
            ->setPartition($partition)
            ->setIsRestored($isRestored)
            ->setTroubleConditionStartUtc($troubleConditionStartUtc)
            ->setTroubleConditionEndUtc($troubleConditionEndUtc)
            ->setTrouble($trouble);
    }
    /**
     * Get Zone value
     * @return int
     */
    public function getZone()
    {
        return $this->Zone;
    }
    /**
     * Set Zone value
     * @param int $zone
     * @return \CustomerManagement\StructType\TroubleConditionsRestoresItem
     */
    public function setZone($zone = null)
    {
        // validation for constraint: int
        if (!is_null($zone) && !(is_int($zone) || ctype_digit($zone))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($zone, true), gettype($zone)), __LINE__);
        }
        $this->Zone = $zone;
        return $this;
    }
    /**
     * Get Partition value
     * @return int
     */
    public function getPartition()
    {
        return $this->Partition;
    }
    /**
     * Set Partition value
     * @param int $partition
     * @return \CustomerManagement\StructType\TroubleConditionsRestoresItem
     */
    public function setPartition($partition = null)
    {
        // validation for constraint: int
        if (!is_null($partition) && !(is_int($partition) || ctype_digit($partition))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($partition, true), gettype($partition)), __LINE__);
        }
        $this->Partition = $partition;
        return $this;
    }
    /**
     * Get IsRestored value
     * @return bool
     */
    public function getIsRestored()
    {
        return $this->IsRestored;
    }
    /**
     * Set IsRestored value
     * @param bool $isRestored
     * @return \CustomerManagement\StructType\TroubleConditionsRestoresItem
     */
    public function setIsRestored($isRestored = null)
    {
        // validation for constraint: boolean
        if (!is_null($isRestored) && !is_bool($isRestored)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isRestored, true), gettype($isRestored)), __LINE__);
        }
        $this->IsRestored = $isRestored;
        return $this;
    }
    /**
     * Get TroubleConditionStartUtc value
     * @return string
     */
    public function getTroubleConditionStartUtc()
    {
        return $this->TroubleConditionStartUtc;
    }
    /**
     * Set TroubleConditionStartUtc value
     * @param string $troubleConditionStartUtc
     * @return \CustomerManagement\StructType\TroubleConditionsRestoresItem
     */
    public function setTroubleConditionStartUtc($troubleConditionStartUtc = null)
    {
        // validation for constraint: string
        if (!is_null($troubleConditionStartUtc) && !is_string($troubleConditionStartUtc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($troubleConditionStartUtc, true), gettype($troubleConditionStartUtc)), __LINE__);
        }
        $this->TroubleConditionStartUtc = $troubleConditionStartUtc;
        return $this;
    }
    /**
     * Get TroubleConditionEndUtc value
     * @return string
     */
    public function getTroubleConditionEndUtc()
    {
        return $this->TroubleConditionEndUtc;
    }
    /**
     * Set TroubleConditionEndUtc value
     * @param string $troubleConditionEndUtc
     * @return \CustomerManagement\StructType\TroubleConditionsRestoresItem
     */
    public function setTroubleConditionEndUtc($troubleConditionEndUtc = null)
    {
        // validation for constraint: string
        if (!is_null($troubleConditionEndUtc) && !is_string($troubleConditionEndUtc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($troubleConditionEndUtc, true), gettype($troubleConditionEndUtc)), __LINE__);
        }
        $this->TroubleConditionEndUtc = $troubleConditionEndUtc;
        return $this;
    }
    /**
     * Get Trouble value
     * @return string|null
     */
    public function getTrouble()
    {
        return $this->Trouble;
    }
    /**
     * Set Trouble value
     * @param string $trouble
     * @return \CustomerManagement\StructType\TroubleConditionsRestoresItem
     */
    public function setTrouble($trouble = null)
    {
        // validation for constraint: string
        if (!is_null($trouble) && !is_string($trouble)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($trouble, true), gettype($trouble)), __LINE__);
        }
        $this->Trouble = $trouble;
        return $this;
    }
}
